<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Colégio Ávilal</title>
    <!-- Bootstrap CSS -->
    <link href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .centered-block {
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
        }
        .content {
            text-align: left;
            text-transform: uppercase;
            margin-top: 25px;
            margin-bottom: 25px;
        }
    </style>
</head>
<body>

<div class="container centered-block">
    <div class="content p-5 border rounded bg-light">
        <h2 class="text-center">Aniversários de Hoje</h2>
        <div id="resultados">
            <?php
            // Conexão com o banco de dados (ajuste de acordo com suas credenciais)
            $host = 'localhost';
            $dbname = 'kaltekgo_fullcalendar';
            $user = 'kaltekgo';
            $password = '2dJxAG2+1c7a1z';

            try {
                $pdo = new PDO("mysql:host=$host;dbname=$dbname", $user, $password);
                $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            } catch (PDOException $e) {
                echo "Erro na conexão: " . $e->getMessage();
                exit();
            }

            // Pegar a data atual no formato YYYY-MM-DD
            $dataAtual = date('Y-m-d');

            // Consulta para buscar dados pela data atual
            $sql = "SELECT * FROM aniversarios WHERE DATE(start) = :dataAtual ORDER BY start ASC";
            $stmt = $pdo->prepare($sql);
            $stmt->bindParam(':dataAtual', $dataAtual);
            $stmt->execute();

            $resultados = $stmt->fetchAll(PDO::FETCH_ASSOC);

            // Função para formatar a data no formato brasileiro
            function formatarDataBrasil($data) {
                return date('d/m/Y', strtotime($data));
            }
            
            function formatarHoraBrasil($data) {
                return date('H:i', strtotime($data));
            }

            // Exibir os dados
            if ($resultados) {
                foreach ($resultados as $row) {
                    echo "<p>ID: " . $row['id'] . "</p>";
                    echo "<p>Nome: " . $row['title'] . "</p>";
                    echo "<p>Data: " . formatarDataBrasil($row['start']) . "</p>";
                    echo "<p>Horário: " . formatarHoraBrasil($row['start']) . "</p>";
                    echo "<hr>";
                }
            } else {
                echo "<p>Nenhum dado encontrado para a data de hoje.</p>";
            }
            ?>
        </div><center><a href="https://agenda.kaltekgoiania.com.br/aniversarios/"><button class="btn btn-success">Voltar</button></a></center>
    </div>
    
</div>


<!-- Bootstrap JS, Popper.js, and jQuery -->
<script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>

</body>
</html>
