<?php
$host = 'localhost';
$dbname = 'kaltekgo_fullcalendar';
$user = 'kaltekgo';
$password = '2dJxAG2+1c7a1z';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname", $user, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    echo "<p class='text-danger'>Erro na conexão: " . $e->getMessage() . "</p>";
    exit();
}

$dataAtual = date('Y-m-d');

$sql = "SELECT * FROM orientacao_educacional_infantil WHERE DATE(start) = :dataAtual ORDER BY start ASC";
$stmt = $pdo->prepare($sql);
$stmt->bindParam(':dataAtual', $dataAtual);
$stmt->execute();
$resultados = $stmt->fetchAll(PDO::FETCH_ASSOC);

function formatarDataBrasil($data) {
    return date('d/m/Y', strtotime($data));
}
function formatarHoraBrasil($data) {
    return date('H:i', strtotime($data));
}

if ($resultados) {
    foreach ($resultados as $row) {
        echo "<div class='border rounded p-3 mb-3 bg-light'>";
        echo "<p><strong>ID:</strong> {$row['id']}</p>";
        echo "<p><strong>Nome:</strong> " . htmlspecialchars($row['title']) . "</p>";
        echo "<p><strong>Data:</strong> " . formatarDataBrasil($row['start']) . "</p>";
        echo "<p><strong>Horário:</strong> " . formatarHoraBrasil($row['start']) . "</p>";
        echo "</div>";
    }
} else {
    echo "<p class='text-center text-muted'>Nenhum dado encontrado para a data de hoje.</p>";
}
?>
