<?php
session_start();
include_once('conexao.php');

// Verificar se o usuário está logado
if (!isset($_SESSION['idUsuario'])) {
    header('Location: login.php'); // Redirecionar para a página de login se não estiver logado
    exit;
}

// Conexão com o banco de dados (substitua pelos seus dados)
include_once('conexao.php');

try {
    $conn = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Consulta para listar as turmas
    $stmt_turmas = $conn->query("SELECT * FROM Turmas_2024");
    $turmas = $stmt_turmas->fetchAll(PDO::FETCH_ASSOC);

    // Consulta para listar as atividades extras
    $stmt_atividades = $conn->query("SELECT * FROM Modalidades_Extras");
    $atividades = $stmt_atividades->fetchAll(PDO::FETCH_ASSOC);

    // Consulta para obter as atividades associadas a cada turma
    $q = "SELECT te.id_turma, te.id_modalidade, CONCAT( a.modalidade , ' - ' , a.turma_modalidade , ' ', a.dia_semana , ' - ', a.professor)  AS atividade_descricao, te.id_turma_modalidade_extra as id_turma_modalidade_extra FROM Turma_modalidade_Extra te INNER JOIN Modalidades_Extras a ON te.id_modalidade = a.id_modalidade WHERE te.id_turma = :id_turma";
    $stmt_associacoes = $conn->prepare($q);
} catch (PDOException $e) {
    echo 'Erro de conexão: ' . $e->getMessage();
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Associar Atividades às Turmas</title>
    <style>
        .turma {
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
    <center> <h1>Associar Atividades às Turmas</h1> </center>
    <hr>
    <?php foreach ($turmas as $turma) : ?>
        <div class="turma">
            <h2><?php echo $turma['Identificador_turma']; ?></h2>
            <ul>
                <?php
                // Executar a consulta para obter as atividades associadas a esta turma
                $stmt_associacoes->bindParam(':id_turma', $turma['id_turma']);
                $stmt_associacoes->execute();
                $atividades_associadas = $stmt_associacoes->fetchAll(PDO::FETCH_ASSOC);

                foreach ($atividades_associadas as $atividade) {
                    echo '<li>' . $atividade['atividade_descricao'] . ' <a = href="excluir_associacao.php?id_turma_modalidade_extra=' . $atividade['id_turma_modalidade_extra'] . '"  > [excluir] </a></li>';
                }
                ?>
            </ul>
            <form action="processar_associacao.php" method="post">
                <input type="hidden" name="id_turma" value="<?php echo $turma['id_turma']; ?>">
                <label for="id_modalidade">Selecione uma atividade extra:</label>
                <select name="id_modalidade" id="id_modalidade">
                    <option value="">Selecione uma atividade</option>
                    <?php foreach ($atividades as $atividade) : ?>
                        <option value="<?php echo $atividade['id_modalidade']; ?>"><?php echo $atividade['modalidade'] . ", " . $atividade['turma_modalidade'] . ", " . $atividade['dia_semana'] . " - " . $atividade['professor']; ?></option>
                    <?php endforeach; ?>
                </select>
                <input type="submit" value="Associar">
            </form>
            <hr>
        </div>
    <?php endforeach; ?>
    <a href="dashboard.php">Voltar para o Dashboard</a>
</body>
</html>
