<?php
session_start();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    //Incluir a conexão com banco de dados
    include_once('conexao.php');

    try {
        $conn = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
        $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        // Verificar se o usuário e senha foram enviados via POST
        if (isset($_POST['email']) && isset($_POST['senha'])) {
            $email = $_POST['email'];
            $senha = $_POST['senha'];

            // Consulta para buscar o usuário pelo e-mail e senha
            $stmt = $conn->prepare("SELECT idUsuario, nome FROM usuarios WHERE email = :email AND senha = :senha");
            $stmt->bindParam(':email', $email);
            $stmt->bindParam(':senha', $senha);
            $stmt->execute();

            // Verificar se o usuário foi encontrado
            if ($stmt->rowCount() == 1) {
                $row = $stmt->fetch(PDO::FETCH_ASSOC);
                $_SESSION['idUsuario'] = $row['idUsuario'];
                $_SESSION['nomeUsuario'] = $row['nome'];
                header('Location: dashboard.php'); // Redirecionar para a página de dashboard após o login
                exit;
            } else {
                $erro = 'Usuário ou senha incorretos.';
            }
        } else {
            $erro = 'Por favor, preencha o e-mail e a senha.';
        }
    } catch (PDOException $e) {
        echo 'Erro de conexão: ' . $e->getMessage();
    }
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Login</title>
</head>
<body>
    <h1>Login</h1>
    <?php if (isset($erro)) echo "<p>$erro</p>"; ?>
    <form action="" method="post">
        <label for="email">E-mail:</label>
        <input type="email" name="email" id="email" required><br>
        <label for="senha">Senha:</label>
        <input type="password" name="senha" id="senha" required><br>
        <input type="submit" value="Login">
    </form>
</body>
</html>