<?php
session_start();
include_once('conexao.php');
?> 

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Listagem de Alunos</title>
    <style>
        table {
            width: 100%;
            border-collapse: collapse;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #f2f2f2;
        }
    </style>
</head>
<body>
    <h1>Listagem de Alunos</h1>
    <table>
        <thead>
            <tr>
                <th>Matrícula SEI</th>
                <th>Nome do Aluno</th>
                <th>Código da Turma</th>
                <th>Identificador da Turma</th>
                <th>Nome do Pai</th>
                <th>Nome da Mãe</th>
            </tr>
        </thead>
        <tbody>
            <?php
            // Configurações de conexão com o banco de dados (substitua pelas suas informações)
  
            // Conecta ao banco de dados
            $conexao = new mysqli($host, $usuario, $senha, $banco);

            // Verifica se a conexão foi estabelecida com sucesso
            if ($conexao->connect_error) {
                die("Erro ao conectar ao banco de dados: " . $conexao->connect_error);
            }

            // Query SQL para selecionar os dados da tabela alunos_2024
            $query = "SELECT matricula_SEI, nome_aluno, codigo_turma, identificador_turma, nome_pai, nome_mae FROM alunos_2024";

            // Executa a consulta
            $resultado = $conexao->query($query);

            // Verifica se a consulta retornou resultados
            if ($resultado->num_rows > 0) {
                // Loop pelos resultados e exibição na tabela HTML
                while ($linha = $resultado->fetch_assoc()) {
                    echo "<tr>";
                    echo "<td>{$linha['matricula_SEI']}</td>";
                    echo "<td>{$linha['nome_aluno']}</td>";
                    echo "<td>{$linha['codigo_turma']}</td>";
                    echo "<td>{$linha['identificador_turma']}</td>";
                    echo "<td>{$linha['nome_pai']}</td>";
                    echo "<td>{$linha['nome_mae']}</td>";
                    echo "</tr>";
                }
            } else {
                echo "<tr><td colspan='6'>Nenhum registro encontrado.</td></tr>";
            }

            // Fecha a conexão com o banco de dados
            $conexao->close();
            ?>
        </tbody>
    </table>
</body>
</html>
