// Função para carregar as opções de categoria
function loadCategories() {
    $.ajax({
        url: 'load_categories.php',
        type: 'GET',
        success: function(response) {
            $('#categorySelect').html(response);
        }
    });
}

$(document).ready(function() {
    // Carregar os produtos na tabela
    function loadProducts() {
        $.ajax({
            url: 'load_products.php',
            type: 'GET',
            success: function(response) {
                $('#productsTable tbody').html(response);
            }
        });
    }

    // Carregar os produtos ao carregar a página
    loadProducts();

// Carregar as categorias ao carregar a página
loadCategories();


    // Ativar edição em linha ao clicar na célula
    $(document).on('click', '.editable', function() {
        $(this).attr('contenteditable', 'true').focus();
        $(this).addClass('edit-mode');
        $(this).closest('tr').find('.save-btn, .cancel-btn').show();
    });

    // Salvar alterações ao clicar em "Salvar"
    $(document).on('click', '.save-btn', function() {
        var id = $(this).closest('tr').find('.product_id').text();
        var name = $(this).closest('tr').find('.product_name').text();
        var description = $(this).closest('tr').find('.product_description').text();
        var price = $(this).closest('tr').find('.product_price').text();
        var categoryId = $(this).closest('tr').find('.categorySelect').val(); // Capturar o valor do campo select

        $.ajax({
            url: 'update_product.php',
            type: 'POST',
            data: {
                id: id,
                name: name,
                description: description,
                price: price,
                category_id: categoryId
            },
            success: function(response) {
                if (response != "1"){
                alert(response);
            }
                //loadProducts();
            }
        });

        $(this).closest('tr').find('.editable').removeAttr('contenteditable').removeClass('edit-mode');
        $(this).closest('tr').find('.save-btn, .cancel-btn').hide();
    });

    // Cancelar edição ao clicar em "Cancelar"
    $(document).on('click', '.cancel-btn', function() {
        $(this).closest('tr').find('.editable').removeAttr('contenteditable').removeClass('edit-mode');
        $(this).closest('tr').find('.save-btn, .cancel-btn').hide();
        //loadProducts();
    });
});
