<?php
include_once("conexao.php");

// Define o número de registros por página
$registros_por_pagina = 20;

// Obtém o número da página atual (ou define como 1 caso não esteja setado)
$pagina_atual = isset($_GET['pagina']) ? (int)$_GET['pagina'] : 1;
$offset = ($pagina_atual - 1) * $registros_por_pagina;

// Consulta o total de registros
$sql_total = "SELECT COUNT(*) AS total FROM acessos";
$result_total = mysqli_query($conn, $sql_total);
$row_total = mysqli_fetch_assoc($result_total);
$total_registros = $row_total['total'];

// Calcula o número total de páginas
$total_paginas = ceil($total_registros / $registros_por_pagina);

// Consulta para buscar registros com limite e offset
$sql = "SELECT * FROM acessos ORDER BY data DESC LIMIT $registros_por_pagina OFFSET $offset";
$resultado_usuario = mysqli_query($conn, $sql);
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <!-- Meta tags Obrigatórias -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@400;700&display=swap" rel="stylesheet">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet">

    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.1.3/css/bootstrap.min.css" integrity="sha384-MCw98/SFnGE8fJT3GXwEOngsV7Zt27NXFoaoApmYm81iuXoPkFOJwJ8ERdknLPMO" crossorigin="anonymous">

    <title>ACESSOS</title>

    <style>
        body {
            /*font-family: 'Barlow', sans-serif;*/
            font-family: "Montserrat", serif;
            font-optical-sizing: auto;
            font-weight: 500;
            font-style: normal;
            font-size: 12;
        }
        table {
            font-size: 12px;
        }
        .thead-dark th {
            font-weight: 700;
        }
    
    </style>
</head>
<body>
<br>
<div class="container">
    <p style="text-align: center;">Total de registros: <strong><?php echo $total_registros; ?></strong></p>
    <table class='table table-striped table-hover table-bordered table-sm' style='width: 80%; margin-left: auto; margin-right: auto;'>
        <thead class='thead-dark'>
            <tr>
                <th scope='col'>LOGIN</th>
                <th scope='col'>NOME</th>
                <th scope='col'>DATA/HOR&Aacute;RIO</th>
            </tr>
        </thead>
        <tbody>
        <?php    
        if (($resultado_usuario) AND ($resultado_usuario->num_rows != 0)) {
            while ($row_usuario = mysqli_fetch_assoc($resultado_usuario)) {    
                echo "<tr>";
                echo "<td>" . $row_usuario['login'] . "</td>";
                echo "<td style='text-transform: uppercase'>" . $row_usuario['nome'] . "</td>";
                $data = $row_usuario['data'];
                $data = strtotime($data);
                echo "<td>" . date('d/m/Y H:i:s', $data) . "</td>";
                echo "</tr>";
            }
        } else {
            echo "<tr>";
            echo "<td colspan='3'><div class='alert alert-danger text-center' role='alert'>Nenhum registro encontrado!</div></td>";
            echo "</tr>";
        }
        ?>    
        </tbody>
    </table>


<!-- Paginação -->
<center>
<nav aria-label="Navegação de página">
    <ul class="pagination justify-content-center">
        <?php 
        $limite_paginas = 5;
        $metade = floor($limite_paginas / 2);

        $inicio = max(1, $pagina_atual - $metade);
        $fim = min($total_paginas, $pagina_atual + $metade);

        if ($inicio == 1) {
            $fim = min($total_paginas, $limite_paginas);
        } elseif ($fim == $total_paginas) {
            $inicio = max(1, $fim - $limite_paginas + 1);
        }

        if ($pagina_atual > 1): ?>
            <li class="page-item">
                <a class="page-link" href="?pagina=<?php echo $pagina_atual - 1; ?>" aria-label="Anterior">
                    <span aria-hidden="true">&laquo;</span>
                </a>
            </li>
        <?php endif; ?>

        <?php for ($i = $inicio; $i <= $fim; $i++): ?>
            <li class="page-item <?php echo ($i == $pagina_atual) ? 'active' : ''; ?>">
                <a class="page-link" href="?pagina=<?php echo $i; ?>"><?php echo $i; ?></a>
            </li>
        <?php endfor; ?>

        <?php if ($pagina_atual < $total_paginas): ?>
            <li class="page-item">
                <a class="page-link" href="?pagina=<?php echo $pagina_atual + 1; ?>" aria-label="Próximo">
                    <span aria-hidden="true">&raquo;</span>
                </a>
            </li>
        <?php endif; ?>
    </ul>
</nav>
</center>
</div>

<script src="https://code.jquery.com/jquery-3.3.1.slim.min.js" integrity="sha384-q8i/X+965DzO0rT7abK41JStQIAqVgRVzpbzo5smXKp4YfRvH+8abtTE1Pi6jizo" crossorigin="anonymous"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.3/umd/popper.min.js" integrity="sha384-ZMP7rVo3mIykV+2+9J3UJ46jBk0WLaUAdn689aCwoqbBJiSnjAK/l8WvCWPIPm49" crossorigin="anonymous"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.1.3/js/bootstrap.min.js" integrity="sha384-ChfqqxuZUCnJSK3+MXmPNIyE6ZbWh2IMqE241rYiqJxyMiZ6OW/JmZQ5stwEULTy" crossorigin="anonymous"></script>
</body>
</html>
