<?php
include_once("conexao.php");

// Captura filtros
$busca_nome = isset($_GET['busca_nome']) ? $_GET['busca_nome'] : '';
$filtro_turma = isset($_GET['filtro_turma']) ? $_GET['filtro_turma'] : '';

// Prepara condições dinâmicas
$where_cond = "1=1";
$params = [];

if (!empty($busca_nome)) {
    $where_cond .= " AND nome_aluno LIKE ?";
    $params[] = "%$busca_nome%";
}

if (!empty($filtro_turma)) {
    $where_cond .= " AND identificador_turma = ?";
    $params[] = $filtro_turma;
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Gerenciar Alunos</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
    <style>
        body {
            margin: 20px;
        }
        h2 {
            margin-top: 40px;
        }
        .filtros {
            margin-bottom: 20px;
        }
    </style>
</head>
<body>

<div class="container">
    <h2>Filtros</h2>
    <form class="form-inline filtros" method="GET" action="">
        <div class="form-group">
            <label for="busca_nome">Nome:</label>
            <input type="text" class="form-control" name="busca_nome" id="busca_nome" value="<?= htmlspecialchars($busca_nome) ?>" placeholder="Buscar por nome">
        </div>
        <div class="form-group">
            <label for="filtro_turma">Turma:</label>
            <select class="form-control" name="filtro_turma" id="filtro_turma">
                <option value="">Todas</option>
                <?php
                $turmas = $conn->query("SELECT DISTINCT identificador_turma FROM cftv ORDER BY identificador_turma");
                while ($turma = $turmas->fetch_assoc()) {
                    $selected = $filtro_turma === $turma['identificador_turma'] ? 'selected' : '';
                    echo "<option value='{$turma['identificador_turma']}' $selected>{$turma['identificador_turma']}</option>";
                }
                ?>
            </select>
        </div>
        <button type="submit" class="btn btn-primary">Filtrar</button>
        <a href="update.php" class="btn btn-default">Limpar</a>
    </form>

    <h2>Alunos Ativos</h2>
    <table class="table table-bordered table-hover">
        <thead>
            <tr>
                <th>Matrícula</th>
                <th>Nome</th>
                <!--th>Login</th-->
                <th>Série</th>
                <th>Turno</th>
                <th>Ação</th>
            </tr>
        </thead>
        <tbody>
            <?php
            $sql = "SELECT nome_aluno, MIN(matricula) AS matricula, MIN(login) AS login, MIN(turno) AS turno, MIN(identificador_turma) AS identificador_turma
FROM cftv
WHERE status_matricula = 'ativo' AND $where_cond
GROUP BY nome_aluno
ORDER BY nome_aluno ASC
";
            $stmt = $conn->prepare($sql);

            if ($params) {
                $types = str_repeat("s", count($params));
                $stmt->bind_param($types, ...$params);
            }

            $stmt->execute();
            $res = $stmt->get_result();
            while ($row = $res->fetch_assoc()) {
                echo "<tr>
                    <td>{$row['matricula']}</td>
                    <td>{$row['nome_aluno']}</td>
                    <!--td>{$row['login']}</td-->
                    <td>{$row['identificador_turma']}</td>
                    <td>{$row['turno']}</td>
                    <td>
                        <form method='POST' action='atualizar_status.php' onsubmit='return confirmar(\"desativar\")'>
                            <input type='hidden' name='matricula' value='{$row['matricula']}'>
                            <input type='hidden' name='status' value='desativo'>
                            <button type='submit' class='btn btn-danger btn-sm'>Desativar</button>
                        </form>
                    </td>
                </tr>";
            }
            ?>
        </tbody>
    </table>

    <h2>Alunos Desativados</h2>
    <table class="table table-bordered table-hover">
        <thead>
            <tr>
                <th>Matrícula</th>
                <th>Nome</th>
                <!--th>Login</th-->
                <th>Série</th>
                <th>Turno</th>
                <th>Ação</th>
            </tr>
        </thead>
        <tbody>
            <?php
            $sql_des = "SELECT nome_aluno, MIN(matricula) AS matricula, MIN(login) AS login, MIN(turno) AS turno, MIN(identificador_turma) AS identificador_turma
FROM cftv
WHERE status_matricula = 'desativo' AND $where_cond
GROUP BY nome_aluno
ORDER BY nome_aluno ASC
";
            $stmt2 = $conn->prepare($sql_des);

            if ($params) {
                $types2 = str_repeat("s", count($params));
                $stmt2->bind_param($types2, ...$params);
            }

            $stmt2->execute();
            $res2 = $stmt2->get_result();
            while ($row = $res2->fetch_assoc()) {
                echo "<tr>
                    <td>{$row['matricula']}</td>
                    <td>{$row['nome_aluno']}</td>
                    <!--td>{$row['login']}</td-->
                    <td>{$row['identificador_turma']}</td>
                    <td>{$row['turno']}</td>
                    <td>
                        <form method='POST' action='atualizar_status.php' onsubmit='return confirmar(\"reativar\")'>
                            <input type='hidden' name='matricula' value='{$row['matricula']}'>
                            <input type='hidden' name='status' value='ativo'>
                            <button type='submit' class='btn btn-success btn-sm'>Ativar</button>
                        </form>
                    </td>
                </tr>";
            }
            ?>
        </tbody>
    </table>
</div>

<script>
function confirmar(acao) {
    return confirm("Tem certeza que deseja " + acao + " este aluno?");
}
</script>

</body>
</html>
