<?php
// aniversariantes.php
header("Content-Type: text/html; charset=utf-8");

// === CONFIG MYSQL ===
$host = "localhost";
$db   = "kaltekgo_avila";
$user = "kaltekgo_admin";
$pass = "kaltek@2024";

// === Conexão PDO ===
try {
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (Exception $e) {
    die("Erro MySQL: " . $e->getMessage());
}

// === Captura mês (default = atual) ===
$mes = isset($_GET['mes']) ? intval($_GET['mes']) : date("n");

// === Query aniversariantes ===
$sql = "
    SELECT 
        nome,
        datanasc,
        curso,
        serie_turma,
        turno,
        TIMESTAMPDIFF(YEAR, datanasc, CURDATE()) AS idade
    FROM alunos_aniversarios
    WHERE MONTH(datanasc) = :mes
    ORDER BY DAY(datanasc) ASC, nome ASC
";
$stmt = $pdo->prepare($sql);
$stmt->execute([':mes' => $mes]);
$dados = $stmt->fetchAll(PDO::FETCH_ASSOC);

// === Nome do mês em português ===
$nomesMes = [
    1=>"Janeiro",2=>"Fevereiro",3=>"Março",4=>"Abril",5=>"Maio",6=>"Junho",
    7=>"Julho",8=>"Agosto",9=>"Setembro",10=>"Outubro",11=>"Novembro",12=>"Dezembro"
];
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Aniversariantes</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <style>
        body { font-family: Arial, sans-serif; background-color: #ffffff; margin: 20px; color: #000; }
        table { white-space: nowrap; width: 100%; border-collapse: collapse; background-color: #fff; text-transform: uppercase; }
        th, td { padding: 12px 15px; text-align: left; font-size: 12px; border: 1px solid #000; }
        th { background-color: #000; color: #fff; }
        tr:nth-child(even) { background-color: #f4f4f4; }
        tr:hover { background-color: #e0e0e0; }
        .table-responsive { overflow-x: auto; }
        .titulo { margin-bottom: 20px; }

        @media (max-width: 768px) {
            .table th:first-child, .table td:first-child { position: sticky; left: 0; background-color: #fff; z-index: 3; border-right: 1px solid #000; }
            .table thead th:first-child { z-index: 4; background-color: #000; color: #fff; }
        }
    </style>
</head>
<body>

<div class="container">
    <h1 class="text-center">🎂</h1>
    <h3 class="titulo text-center text-uppercase">Aniversariantes de <?= $nomesMes[$mes] ?></h3>

    <div class="text-center" style="margin-bottom:15px;">
        <button class="btn btn-default text-uppercase" onclick="navegarMes(-1)"><< Mês Anterior</button>
        <button class="btn btn-default text-uppercase" onclick="navegarMes(1)">Próximo Mês >></button>
    </div>

    <!-- Filtro por curso -->
    <div class="text-center text-uppercase" style="margin-bottom:15px;">
        <label for="filtroCurso">Filtrar por curso:</label><br>
        <select id="filtroCurso" class="form-control text-center text-uppercase" style="width: 400px; display: inline-block; margin-top:5px;">
            <option value="">Todos</option>
            <option value="Infantil">Educação Infantil (Infantil 2 ao 5)</option>
            <option value="Ensino Fundamental 1ª Fase">Ensino Fundamental I (1º ao 5º ano</option>
            <option value="Ensino Fundamental 2ª Fase">Ensino Fundamental II (6º ao 9º ano)</option>
            <option value="Ensino Médio">Ensino Médio (1º a 3º série)</option>
        </select>
    </div>

    <table class="table table-bordered table-striped">
        <thead>
            <tr>
                <th>Nome</th>
                <th>Data de Nascimento</th>
                <th>Idade</th>
                <th>Curso</th>
                <th>Turma</th>
                <th>Turno</th>
            </tr>
        </thead>
        <tbody id="tabelaAniversariantes">
            <?php if(count($dados) > 0): ?>
                <?php foreach($dados as $d): ?>
                    <tr data-curso="<?= htmlspecialchars($d['curso']) ?>">
                        <td><?= htmlspecialchars($d['nome']) ?></td>
                        <td><?= date("d/m/Y", strtotime($d['datanasc'])) ?></td>
                        <td><?= $d['idade'] ?> anos</td>
                        <td><?= htmlspecialchars($d['curso']) ?></td>
                        <td><?= htmlspecialchars($d['serie_turma']) ?></td>
                        <td><?= htmlspecialchars($d['turno']) ?></td>
                    </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <tr><td colspan="6" class="text-center">Nenhum aniversariante em <?= $nomesMes[$mes] ?></td></tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>

<script>
// Navegar entre meses
function navegarMes(delta) {
    var url = new URL(window.location.href);
    var mes = parseInt(url.searchParams.get("mes") || <?= $mes ?>);
    mes += delta;
    if(mes < 1) mes = 12;
    if(mes > 12) mes = 1;
    url.searchParams.set("mes", mes);
    window.location.href = url.toString();
}

// Filtro por curso
$("#filtroCurso").on("change", function() {
    var cursoSelecionado = $(this).val();
    $("#tabelaAniversariantes tr").each(function() {
        var curso = $(this).data("curso");
        if(cursoSelecionado === "" || curso === cursoSelecionado) {
            $(this).show();
        } else {
            $(this).hide();
        }
    });
});
</script>

</body>
</html>
