<?php
session_start();

// ==== Conexão com o banco (PDO) ====
$host = "localhost";
$user = "kaltekgo_admin";
$pass = "kaltek@2024";
$db   = "kaltekgo_avila";

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Erro na conexão: " . $e->getMessage());
}

$cpf_responsavel = $_SESSION['cpf'] ?? null;

if (!$cpf_responsavel) {
    die("CPF do responsável não encontrado na sessão.");
}

$sql = "
    SELECT matricula, nomealuno, identificadorturma
    FROM alunos_responsaveis
    WHERE (cpfpai = :cpf OR cpfmae = :cpf)
  AND (identificadorturma = '6º A - (2025)' OR identificadorturma = '6º B - (2025)' OR identificadorturma = '7ºA - (2025)' OR identificadorturma = '7ºB - (2025)')
    ORDER BY nomeAluno
";

$stmt = $pdo->prepare($sql);
$stmt->execute(['cpf' => $cpf_responsavel]);
$filhos = $stmt->fetchAll(PDO::FETCH_ASSOC);

if (!$filhos) {
    die("<h3>Nenhum aluno encontrado para este responsável.</h3>");
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Dados dos Alunos</title>

    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
</head>

<body style="background: #f5f5f5">

<div class="container" style="margin-top: 30px; background: #fff; padding: 30px; border-radius: 4px;">

    <h3>Aula de Campo - Caldas Novas</h3>
    <hr>

    <!-- FORMÚLARIO ÚNICO PARA TODOS OS ALUNOS -->
    <form action="salvar.php" method="POST">

        <?php foreach ($filhos as $aluno): ?>

            <div class="panel panel-primary">
                <div class="panel-heading">
                    <b><?= htmlspecialchars($aluno['nomealuno']) ?></b>
                    — <?= htmlspecialchars($aluno['identificadorturma']) ?>
                </div>

                <div class="panel-body">

                    <!-- Matrícula oculta -->
                    <input type="hidden" name="id_aluno[]" value="<?= $aluno['matricula'] ?>">

                    <div class="row">
                        <div class="col-sm-3 form-group">
                            <label>Matrícula</label>
                            <input type="text" class="form-control" value="<?= $aluno['matricula'] ?>" readonly>
                        </div>

                        <div class="col-sm-6 form-group">
                            <label>Nome do Aluno</label>
                            <input type="text" class="form-control" name="nome_aluno[]"
                                   value="<?= htmlspecialchars($aluno['nomealuno']) ?>" readonly>
                        </div>

                        <div class="col-sm-3 form-group">
                            <label>Série</label>
                            <input type="text" class="form-control" name="serie_aluno[]"
                                   value="<?= htmlspecialchars($aluno['identificadorturma']) ?>" readonly>
                        </div>
                    </div>

                    <!-- RG -->
                    <div class="row">
                        <div class="col-sm-4 form-group">
                            <label>Número do RG</label>
                            <input type="text" name="rg_numero[]" class="form-control text-uppercase" required>
                        </div>

                        <div class="col-sm-4 form-group">
                            <label>Data de Emissão</label>
                            <input type="date" name="rg_data[]" class="form-control" required>
                        </div>

                        <div class="col-sm-4 form-group">
                            <label>Órgão Emissor</label>
                            <input type="text" name="rg_local[]" class="form-control text-uppercase" required>
                        </div>
                    </div>

                    <!-- CPF + Nascimento -->
                    <div class="row">
                        <div class="col-sm-6 form-group">
                            <label>CPF do Aluno</label>
                            <input type="text" name="cpf_aluno[]" maxlength="11" class="form-control"
                                   oninput="this.value=this.value.replace(/[^0-9]/g,'')" required>
                        </div>

                        <div class="col-sm-6 form-group">
                            <label>Data de Nascimento</label>
                            <input type="date" name="data_nascimento[]" class="form-control" required>
                        </div>
                    </div>

                </div>
            </div>

        <?php endforeach; ?>

        <button class="btn btn-primary btn-lg btn-block" type="submit">
            Salvar Dados
        </button>

    </form>

</div>

</body>
</html>
