<?php
// index.php
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pesquisa por CPF</title>
    <style>
        body {
            margin: 0;
            height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            background-color: #f2f2f2;
            font-family: Arial, sans-serif;
        }

        .container {
            text-align: center;
            background: white;
            padding: 40px;
            border-radius: 15px;
            box-shadow: 0 0 10px rgba(0,0,0,0.2);
        }

        label {
            display: block;
            font-size: 18px;
            margin-bottom: 10px;
            color: #333;
        }

        input[type="text"] {
            width: 250px;
            padding: 10px;
            font-size: 16px;
            border: 1px solid #ccc;
            border-radius: 8px;
            text-align: center;
        }

        button {
            margin-top: 15px;
            padding: 10px 25px;
            font-size: 16px;
            background-color: #007BFF;
            color: white;
            border: none;
            border-radius: 8px;
            cursor: pointer;
        }

        button:hover {
            background-color: #0056b3;
        }

        .erro {
            color: red;
            margin-top: 10px;
            font-size: 14px;
        }
    </style>
</head>
<body>

    <div class="container">
        <form id="formCPF" action="pesquisar.php" method="post">
            <label for="cpf">Digite o seu CPF para iniciar</label>
            <input type="text" id="cpf" name="cpf" maxlength="14" placeholder="000.000.000-00" required>
            <div id="msgErro" class="erro"></div>
            <button type="submit">Iniciar a Pesquisa</button>
        </form>
    </div>

    <script>
        const cpfInput = document.getElementById('cpf');
        const msgErro = document.getElementById('msgErro');
        const form = document.getElementById('formCPF');

        // Máscara automática do CPF
        cpfInput.addEventListener('input', () => {
            let value = cpfInput.value.replace(/\D/g, ''); // Remove tudo que não for número
            if (value.length > 11) value = value.slice(0, 11);
            
            // Aplica a máscara
            value = value.replace(/(\d{3})(\d)/, '$1.$2');
            value = value.replace(/(\d{3})(\d)/, '$1.$2');
            value = value.replace(/(\d{3})(\d{1,2})$/, '$1-$2');
            cpfInput.value = value;
        });

        // Validação simples de CPF (estrutura e dígitos verificadores)
        function validarCPF(cpf) {
            cpf = cpf.replace(/[^\d]+/g,'');
            if (cpf.length !== 11 || /^(\d)\1+$/.test(cpf)) return false;
            let soma = 0, resto;

            for (let i = 1; i <= 9; i++) soma += parseInt(cpf.substring(i-1, i)) * (11 - i);
            resto = (soma * 10) % 11;
            if (resto === 10 || resto === 11) resto = 0;
            if (resto !== parseInt(cpf.substring(9, 10))) return false;

            soma = 0;
            for (let i = 1; i <= 10; i++) soma += parseInt(cpf.substring(i-1, i)) * (12 - i);
            resto = (soma * 10) % 11;
            if (resto === 10 || resto === 11) resto = 0;
            if (resto !== parseInt(cpf.substring(10, 11))) return false;

            return true;
        }

        // Intercepta o envio do formulário
        form.addEventListener('submit', (e) => {
            const cpf = cpfInput.value;
            if (!validarCPF(cpf)) {
                e.preventDefault();
                msgErro.textContent = 'CPF inválido. Verifique e tente novamente.';
                cpfInput.focus();
            } else {
                msgErro.textContent = '';
            }
        });
    </script>

</body>
</html>
