<?php
// pesquisar.php
session_start();

// ==== CONEXÃO COM O BANCO (PDO) ====
$host = "localhost";
$user = "kaltekgo_admin";
$pass = "kaltek@2024";
$db   = "kaltekgo_avila"; // banco de dados correto

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Erro na conexão: " . $e->getMessage());
}

// ==== RECEBE O CPF ====
if (!isset($_POST['cpf']) || empty($_POST['cpf'])) {
    die("<center><h3>CPF não informado.</h3><a href='index.php'>Voltar</a></center>");
}

$cpf = preg_replace('/\D/', '', $_POST['cpf']); // remove pontos e traços

// ==== CONSULTA NO BANCO ====
$sql = "SELECT matricula, nomealuno, identificadorturma, nomepai, nomemae, cpfpai, cpfmae 
FROM alunos_responsaveis 
WHERE (cpfpai = :cpf OR cpfmae = :cpf)
  AND (identificadorturma = '6º A - (2025)' OR identificadorturma = '6º B - (2025)' OR identificadorturma = '7ºA - (2025)' OR identificadorturma = '7ºB - (2025)');
";

$stmt = $pdo->prepare($sql);
$stmt->bindValue(':cpf', $cpf);
$stmt->execute();

if ($stmt->rowCount() > 0) {
    $dados = $stmt->fetch(PDO::FETCH_ASSOC);

    // ==== INICIA A SESSÃO ====
    //$_SESSION['id'] = $dados['id'];
    $_SESSION['matricula'] = $dados['matricula'];
    $_SESSION['aluno'] = $dados['nomealuno'];
    $_SESSION['turma'] = $dados['identificadorturma'];

    if ($dados['cpfpai'] === $cpf) {
        $_SESSION['responsavel'] = $dados['nomepai'];
        $_SESSION['cpf'] = $dados['cpfpai'];
        $_SESSION['tipo'] = 'pai';
    } elseif ($dados['cpfmae'] === $cpf) {
        $_SESSION['responsavel'] = $dados['nomemae'];
        $_SESSION['cpf'] = $dados['cpfmae'];
        $_SESSION['tipo'] = 'mae';
    }

    // ==== REDIRECIONA PARA O ARQUIVO CORRETO ====
    header("Location: dadosalunos.php");
    exit;

} else {
    echo "<center>
            <h3>CPF não encontrado no sistema.</h3>
            <a href='index.php'>Voltar e tentar novamente</a>
          </center>";
}
?>
