<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

require 'vendor/autoload.php';

use Dompdf\Dompdf;
use Dompdf\Options;

// ==========================
//  CONEXÃO COM PDO
// ==========================
$host = "localhost";
$user = "kaltekgo_admin";
$pass = "kaltek@2024";
$db   = "kaltekgo_avila";

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Erro na conexão: " . $e->getMessage());
}

// ==========================
// BUSCAR DADOS DO BANCO
// ==========================
$sql = "SELECT 
            id_aluno, nome_aluno, serie_aluno, rg_numero, 
            rg_data, rg_local, cpf, data_nascimento, data_registro
        FROM caldasnovas
        ORDER BY nome_aluno ASC";

$stmt = $pdo->prepare($sql);
$stmt->execute();
$dados = $stmt->fetchAll(PDO::FETCH_ASSOC);

// ==========================
// MONTAR O HTML DO PDF
// ==========================
$html = "
<style>
    @page {
        margin: 40px;
    }

    body { 
        font-family: Arial, sans-serif; 
        background-color: #ffffff;
        margin: 0;
        padding: 0;
        color: #000000;
    }

    table {
        width: 100%;
        border-collapse: collapse;
        background-color: #ffffff;
        table-layout: fixed;   /* Isso faz a tabela NÃO estourar a página */
        font-size: 10px;
    }

    th, td {
        padding: 5px;
        text-align: left;
        border: 1px solid #000;
        word-wrap: break-word;
    }

    th {
        background-color: #000;
        color: #fff;
        font-size: 10px;
    }

    tr:nth-child(even) {
        background-color: #f4f4f4;
    }
</style>
<h2 style='text-align:center;'>Relatório de Alunos - Caldas Novas</h2>
<table>
    <thead>
        <tr style='background:#f0f0f0;text-transform: uppercase;'>
            <th>Matricula</th>
            <th>Nome</th>
            <th>Série</th>
            <th>RG</th>
            <th>Data RG</th>
            <th>Orgão Emissor</th>
            <th>CPF</th>
            <th>Nascimento</th>
            <!--th>Registrado em</th-->
        </tr>
    </thead>
    <tbody>
";

if (count($dados) > 0) {
    foreach ($dados as $linha) {

        $html .= "
        <tr style='text-transform: uppercase;'>
            <td>{$linha['id_aluno']}</td>
            <td>{$linha['nome_aluno']}</td>
            <td>{$linha['serie_aluno']}</td>
            <td>{$linha['rg_numero']}</td>
            <td>" . ($linha['rg_data'] ? date('d/m/Y', strtotime($linha['rg_data'])) : '') . "</td>
            <td>{$linha['rg_local']}</td>
            <td>{$linha['cpf']}</td>
            <td>" . ($linha['data_nascimento'] ? date('d/m/Y', strtotime($linha['data_nascimento'])) : '') . "</td>
            <!--td>" . ($linha['data_registro'] ? date('d/m/Y H:i', strtotime($linha['data_registro'])) : '') . "</td-->
        </tr>";
    }
} else {
    $html .= "<tr><td colspan='9' style='text-align:center;'>Nenhum registro encontrado.</td></tr>";
}

$html .= "</tbody></table>";

// ==========================
// GERAR PDF COM DOMPDF
// ==========================
$options = new Options();
$options->set('defaultFont', 'Helvetica');

$dompdf = new Dompdf($options);

$dompdf->loadHtml($html);
//$dompdf->setPaper('A4', 'landscape');   // Paisagem (muda para portrait se quiser)
$dompdf->setPaper('A4', 'portrait');

$dompdf->render();

// Baixar o arquivo:
$dompdf->stream("relatorio_caldasnovas.pdf", ["Attachment" => false]);
