<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// ======================================================
//  CONEXÃO COM PDO
// ======================================================
$host = "localhost";
$user = "kaltekgo_admin";
$pass = "kaltek@2024";
$db   = "kaltekgo_avila";

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Erro na conexão: " . $e->getMessage());
}

// ======================================================
//  VERIFICA ENVIO POST
// ======================================================
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    die("Acesso inválido.");
}

// ======================================================
//  RECEBE ARRAYS DO FORMULÁRIO
// ======================================================
$id_aluno        = $_POST['id_aluno'] ?? [];
$nome_aluno      = $_POST['nome_aluno'] ?? [];
$serie_aluno     = $_POST['serie_aluno'] ?? [];
$rg_numero       = $_POST['rg_numero'] ?? [];
$rg_data         = $_POST['rg_data'] ?? [];
$rg_local        = $_POST['rg_local'] ?? [];
$cpf_aluno       = $_POST['cpf_aluno'] ?? [];
$data_nascimento = $_POST['data_nascimento'] ?? [];

$total = count($id_aluno);

if ($total === 0) {
    die("Nenhum dado recebido.");
}

// ======================================================
//  LOOP PARA SALVAR CADA ALUNO
// ======================================================
for ($i = 0; $i < $total; $i++) {

    if (!isset($id_aluno[$i]) || trim($id_aluno[$i]) === '') {
        continue;
    }

    $id     = trim($id_aluno[$i]);
    $nome   = trim($nome_aluno[$i] ?? '');
    $serie  = trim($serie_aluno[$i] ?? '');
    $rgNum  = trim($rg_numero[$i] ?? '');
    $rgDat  = trim($rg_data[$i] ?? '') ?: null;
    $rgLoc  = trim($rg_local[$i] ?? '');
    $cpf    = trim($cpf_aluno[$i] ?? '');
    $nasc   = trim($data_nascimento[$i] ?? '') ?: null;

    // -----------------------------------------
    // VERIFICA SE JÁ EXISTE
    // -----------------------------------------
    $sql = "SELECT id_aluno FROM caldasnovas WHERE id_aluno = ?";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$id]);
    $exists = $stmt->fetchColumn();

    if ($exists) {

        // -----------------------------------------
        // UPDATE
        // -----------------------------------------
        $sql = "UPDATE caldasnovas SET 
                    nome_aluno = ?, 
                    serie_aluno = ?, 
                    rg_numero = ?, 
                    rg_data = ?, 
                    rg_local = ?, 
                    cpf = ?, 
                    data_nascimento = ?
                WHERE id_aluno = ?";

        $up = $pdo->prepare($sql);
        $up->execute([
            $nome,
            $serie,
            $rgNum,
            $rgDat,
            $rgLoc,
            $cpf,
            $nasc,
            $id
        ]);

    } else {

        // -----------------------------------------
        // INSERT 100% CORRIGIDO
        // 8 campos → 8 valores
        // -----------------------------------------
        $sql = "INSERT INTO caldasnovas 
                (id_aluno, nome_aluno, serie_aluno, rg_numero, rg_data, rg_local, cpf, data_nascimento)
                VALUES (?, ?, ?, ?, ?, ?, ?, ?)";

        $in = $pdo->prepare($sql);
        $in->execute([
            $id,
            $nome,
            $serie,
            $rgNum,
            $rgDat,
            $rgLoc,
            $cpf,
            $nasc
        ]);
    }
}
?>

<!-- ======================================================
     MODAL DE SUCESSO
====================================================== -->
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<div class="modal fade show" id="successModal" style="display:block; background:rgba(0,0,0,0.6);" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">

            <div class="modal-header bg-success text-white">
                <h5 class="modal-title">Sucesso!</h5>
            </div>

            <div class="modal-body">
                <p style="font-size:18px;">Todos os dados foram salvos com sucesso!</p>
                <p>Você será redirecionado em instantes...</p>
            </div>

        </div>
    </div>
</div>

<script>
setTimeout(() => {
    window.location.href = "https://colegioavila.com.br";
}, 2000);
</script>
