<?php
// Conexão
$pdo = new PDO("mysql:host=localhost;dbname=kaltekgo_avila;charset=utf8", "kaltekgo_admin", "kaltek@2024");
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

date_default_timezone_set('America/Sao_Paulo');

// Pega semana e ano via GET
$ano = isset($_GET['ano']) ? (int)$_GET['ano'] : date("Y");
$semana = isset($_GET['semana']) ? (int)$_GET['semana'] : date("W");

// Segunda-feira
$segunda = new DateTime();
$segunda->setISODate($ano, $semana, 1);
$dataInicio = $segunda->format('Y-m-d');

// Domingo
$domingo = new DateTime();
$domingo->setISODate($ano, $semana, 7);
$dataFim = $domingo->format('Y-m-d');

// Consulta
$sql = "SELECT avaliacao, turma, trimestre, disciplina, data_previsao, data_entrega 
        FROM entrega_avaliacao
        WHERE data_previsao BETWEEN :inicio AND :fim
        ORDER BY data_previsao ASC";
$stmt = $pdo->prepare($sql);
$stmt->execute([':inicio' => $dataInicio, ':fim' => $dataFim]);
$dadosSemana = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Retorna tabela HTML
ob_start();
?>
<h4 class="modal-title">
  Avaliações da Semana <?= $semana ?>/<?= $ano ?>
  (<?= $segunda->format('d/m/Y') ?> - <?= $domingo->format('d/m/Y') ?>)
</h4>

<?php if (count($dadosSemana) > 0): ?>
<div class="table-responsive">
<table class="table table-bordered table-hover">
  <thead>
    <tr class="info">
      <th style="background:#000;color:#fff;">Avaliação</th>
      <th style="background:#000;color:#fff;">Turma</th>
      <th style="background:#000;color:#fff;">Trimestre</th>
      <th style="background:#000;color:#fff;">Disciplina</th>
      <th style="background:#000;color:#fff;">Data Previsão</th>
      <th style="background:#000;color:#fff;">Data Entrega</th>
      <th style="background:#000;color:#fff;">Status</th>
    </tr>
  </thead>
  <tbody>
    <?php 
    $hoje = new DateTime();
    foreach ($dadosSemana as $linha): 
        $data_previsao = $linha['data_previsao'] ? new DateTime($linha['data_previsao']) : null;
        $data_entrega = $linha['data_entrega'] ? new DateTime($linha['data_entrega']) : null;

        $status = "";
        if (is_null($data_entrega)) {
            $diferenca = $hoje->diff($data_previsao)->days;
            $status = ($hoje < $data_previsao) 
                ? "<span style='color:blue;'>Faltam $diferenca dias</span>"
                : "<span style='color:red;'>$diferenca dias atrasado</span>";
        } else {
            if ($data_entrega == $data_previsao) {
                $status = "<span style='color:green;'>Entregue no prazo</span>";
            } elseif ($data_entrega < $data_previsao) {
                $diferenca = $data_previsao->diff($data_entrega)->days;
                $status = "<span style='color:green;'>Entregue $diferenca dias adiantado</span>";
            } else {
                $diferenca = $data_entrega->diff($data_previsao)->days;
                $status = "<span style='color:red;'>Entregue $diferenca dias atrasado</span>";
            }
        }
    ?>
      <tr>
        <td><?= htmlspecialchars($linha['avaliacao']) ?></td>
        <td><?= htmlspecialchars($linha['turma']) ?></td>
        <td><?= htmlspecialchars($linha['trimestre']) ?></td>
        <td><?= htmlspecialchars($linha['disciplina']) ?></td>
        <td><?= $data_previsao ? $data_previsao->format('d/m/Y') : '---' ?></td>
        <td><?= $data_entrega ? $data_entrega->format('d/m/Y') : '<span class="text-danger">Não entregue</span>' ?></td>
        <td><?= $status ?></td>
      </tr>
    <?php endforeach; ?>
  </tbody>
</table>
</div>
<?php else: ?>
  <p class="text-center text-muted">Nenhuma avaliação prevista nesta semana.</p>
<?php endif; ?>
<?php
echo ob_get_clean();
