<?php
// Conexão com o banco
$host = 'localhost';
$db = 'kaltekgo_avila';
$user = 'kaltekgo_admin';
$pass = 'kaltek@2024';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Erro na conexão: " . $e->getMessage());
}

// ===================== CONSULTA DA SEMANA =====================
date_default_timezone_set('America/Sao_Paulo');
$hoje = new DateTime();
$semana = $hoje->format("W");
$ano = $hoje->format("Y");

// Segunda-feira
$segunda = clone $hoje;
$segunda->setISODate($ano, $semana, 1);
$dataInicio = $segunda->format('Y-m-d');

// Domingo
$domingo = clone $hoje;
$domingo->setISODate($ano, $semana, 7);
$dataFim = $domingo->format('Y-m-d');

// Buscar registros da semana
$sqlSemana = "SELECT avaliacao, turma, trimestre, disciplina, data_previsao, data_entrega
              FROM entrega_avaliacao
              WHERE data_previsao BETWEEN :inicio AND :fim
              ORDER BY data_previsao ASC";
$stmtSemana = $pdo->prepare($sqlSemana);
$stmtSemana->execute([':inicio' => $dataInicio, ':fim' => $dataFim]);
$dadosSemana = $stmtSemana->fetchAll(PDO::FETCH_ASSOC);


// Itens por página
$itensPorPagina = 6;

// Página atual
$paginaAtual = isset($_GET['pagina']) ? (int)$_GET['pagina'] : 1;
$paginaAtual = max($paginaAtual, 1); // Garante que seja pelo menos 1
$offset = ($paginaAtual - 1) * $itensPorPagina;

// Montagem dos filtros (mantém igual ao que você já tinha)
$condicoes = [];
$parametros = [];

if (!empty($_GET['data_inicial'])) {
    $condicoes[] = 'data_previsao >= :data_inicial';
    $parametros[':data_inicial'] = $_GET['data_inicial'];
}
if (!empty($_GET['data_final'])) {
    $condicoes[] = 'data_previsao <= :data_final';
    $parametros[':data_final'] = $_GET['data_final'];
}


if (!empty($_GET['avaliacao'])) {
    $condicoes[] = 'avaliacao = :avaliacao';
    $parametros[':avaliacao'] = $_GET['avaliacao'];
}
if (!empty($_GET['turma'])) {
    $condicoes[] = 'turma = :turma';
    $parametros[':turma'] = $_GET['turma'];
}
if (!empty($_GET['trimestre'])) {
    $condicoes[] = 'trimestre = :trimestre';
    $parametros[':trimestre'] = $_GET['trimestre'];
}
if (!empty($_GET['disciplina'])) {
    $condicoes[] = 'disciplina = :disciplina';
    $parametros[':disciplina'] = $_GET['disciplina'];
}

// Consulta total de registros (sem LIMIT)
$sqlTotal = "SELECT COUNT(*) FROM entrega_avaliacao";
if (count($condicoes) > 0) {
    $sqlTotal .= " WHERE " . implode(' AND ', $condicoes);
}
$stmtTotal = $pdo->prepare($sqlTotal);
$stmtTotal->execute($parametros);
$totalRegistros = $stmtTotal->fetchColumn();
$totalPaginas = ceil($totalRegistros / $itensPorPagina);

// Consulta com LIMIT e OFFSET
$sql = "SELECT id, avaliacao, turma, trimestre, disciplina, data_previsao, data_entrega 
        FROM entrega_avaliacao";
if (count($condicoes) > 0) {
    $sql .= " WHERE " . implode(' AND ', $condicoes);
}
$sql .= " ORDER BY data_previsao ASC LIMIT :limit OFFSET :offset";

$stmt = $pdo->prepare($sql);
foreach ($parametros as $chave => $valor) {
    $stmt->bindValue($chave, $valor);
}
$stmt->bindValue(':limit', $itensPorPagina, PDO::PARAM_INT);
$stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
$stmt->execute();
$dados = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Controle de Entregas</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
            background-color: #fff;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            background-color: #fff;
            min-width: 700px;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
            text-transform: uppercase;
        }
        th, td {
            padding: 10px;
            font-size: 12px;
            border: 1px solid #000;
            text-align: left;
        }
        th {
            background-color: #000;
            color: #fff;
        }
       
        tr:nth-child(even) {
            background-color: #f4f4f4;
        }
        tr:hover {
            background-color: #e0e0e0;
        }
        .margin {
            margin-bottom: 8px;
        }
         .header-bar {
            width: 100%;
            padding: 10px;
            background: #f5f5f5;
            border-bottom: 1px solid #ddd;
            position: fixed;
            top: 0;
            right: 0;
            left: 0;
            z-index: 1000;
        }
        .header-bar .header-content {
            display: flex;
            justify-content: flex-end;
            align-items: center;
        }
        .header-bar .welcome {
            font-size: 16px;
            font-weight: bold;
            margin-right: 10px;
        }
        .header-bar .btn {
            margin-left: 5px;
        }
        
    </style>
</head>
<body>
<div class="header-bar">
    <div class="container header-content">
        <span class="welcome">Seja bem-vindo, <?php echo htmlspecialchars($userlogin); ?></span>
        <a href="dashboard.php" class="btn btn-primary btn-sm">Principal</a>
        <a href="alterarsenha.php" class="btn btn-warning btn-sm">Alterar Senha</a>
        <a href="logout.php" class="btn btn-danger btn-sm">Sair</a>
    </div>
</div><br>
<div class="container">
    <h2 class="text-center">Controle de Entregas de Avaliações</h2>

    <!-- Filtros -->
    <form method="GET" class="margin">
        <div class="row">
            <div class="col-md-3">
                <label>Avaliação</label>
                <select name="avaliacao" class="form-control text-uppercase margin">
                    <option value="">Todas</option>
                    <option value="P1" <?= (@$_GET['avaliacao'] == 'P1') ? 'selected' : '' ?>>P1</option>
                    <option value="P2" <?= (@$_GET['avaliacao'] == 'P2') ? 'selected' : '' ?>>P2</option>
                    <option value="2º Chamada(P1)" <?= (@$_GET['avaliacao'] == '2º Chamada(P1)') ? 'selected' : '' ?>>2º Chamada(P1)</option>
                    <option value="2º Chamada(P2)" <?= (@$_GET['avaliacao'] == '2º Chamada(P2)') ? 'selected' : '' ?>>2º Chamada(P2)</option>
                    <option value="Recuperação Trimestre" <?= (@$_GET['avaliacao'] == 'Recuperação Trimestre') ? 'selected' : '' ?>>Recuperação Trimestre</option>
                </select>
            </div>
            <div class="col-md-3">
                <label>Turma</label>
                <select name="turma" class="form-control text-uppercase margin">
                    <option value="">Todas</option>
                    <option value="1º Ano" <?= (@$_GET['turma'] == '1º Ano') ? 'selected' : '' ?>>1º Ano</option>
                    <option value="2º Ano" <?= (@$_GET['turma'] == '2º Ano') ? 'selected' : '' ?>>2º Ano</option>
                    <option value="3º Ano" <?= (@$_GET['turma'] == '3º Ano') ? 'selected' : '' ?>>3º Ano</option>
                    <option value="4º Ano" <?= (@$_GET['turma'] == '4º Ano') ? 'selected' : '' ?>>4º Ano</option>
                    <option value="5º Ano" <?= (@$_GET['turma'] == '5º Ano') ? 'selected' : '' ?>>5º Ano</option>
                </select>
            </div>
            <div class="col-md-3">
                <label>Trimestre</label>
                <select name="trimestre" class="form-control text-uppercase margin">
                    <option value="">Todos</option>
                    <option value="1º Trimestre" <?= (@$_GET['trimestre'] == '1º Trimestre') ? 'selected' : '' ?>>1º Trimestre</option>
                    <option value="2º Trimestre" <?= (@$_GET['trimestre'] == '2º Trimestre') ? 'selected' : '' ?>>2º Trimestre</option>
                    <option value="3º Trimestre" <?= (@$_GET['trimestre'] == '3º Trimestre') ? 'selected' : '' ?>>3º Trimestre</option>
                </select>
            </div>
            <div class="col-md-3">
                <label>Disciplina</label>
                <select name="disciplina" class="form-control text-uppercase margin">
                    <option value="">Todas</option>
                    <?php
                    $disciplinas = $pdo->query("SELECT DISTINCT nomeDisciplina FROM disciplinas_fundamental1 ORDER BY nomeDisciplina ASC")->fetchAll();
                    foreach ($disciplinas as $disc) {
                        $selected = (@$_GET['disciplina'] == $disc['nomeDisciplina']) ? 'selected' : '';
                        echo "<option value='{$disc['nomeDisciplina']}' $selected>{$disc['nomeDisciplina']}</option>";
                    }
                    ?>
                </select>
            </div>
            
            
            <div class="col-md-3">
    <label>Data Inicial</label>
    <input type="date" name="data_inicial" class="form-control text-uppercase margin" value="<?= htmlspecialchars(@$_GET['data_inicial']) ?>">
</div>
<div class="col-md-3">
    <label>Data Final</label>
    <input type="date" name="data_final" class="form-control text-uppercase margin" value="<?= htmlspecialchars(@$_GET['data_final']) ?>">
</div>

        </div>
    
        
        <button type="submit" class="btn btn-success ">Filtrar</button>
        <a href="index.php" class="btn btn-default">Limpar</a>
        <button type="button" class="btn btn-primary" onclick="window.location.href='cadastrar-avaliacao.php'">Cadastrar Avaliação</button>
        <button type="button" class="btn btn-info" onclick="$('#modalSemana').modal('show')">
                📅 Ver Avaliações da Semana
            </button>
    </form>

    <!-- Tabela -->
    <div class="table-responsive">
    <table class="table table-bordered table-hover">
        <thead>
            <tr>
                <th>Avaliação</th>
                <th>Turma</th>
                <th>Trimestre</th>
                <th>Disciplina</th>
                <th>Data Previsão</th>
                <th>Data Entrega</th>
                <th>Status</th>
                <th>Ação</th>
            </tr>
        </thead>
        <tbody>
            <?php
            date_default_timezone_set('America/Sao_Paulo');
            $hoje = new DateTime();

            if (count($dados) === 0) {
                echo '<tr><td colspan="8" class="text-center">Nenhum dado encontrado</td></tr>';
            } else {
                foreach ($dados as $linha) {
                    $data_previsao = $linha['data_previsao'] ? new DateTime($linha['data_previsao']) : null;
                    $data_entrega = $linha['data_entrega'] ? new DateTime($linha['data_entrega']) : null;

                    $status = "";

                    if (is_null($data_entrega)) {
                        $diferenca = $hoje->diff($data_previsao)->days;
                        if ($hoje < $data_previsao) {
                            $status = "<span style='color:blue;'>Faltam $diferenca dias</span>";
                        } else {
                            $status = "<span style='color:red;'>$diferenca dias atrasado</span>";
                        }
                    } else {
                        if ($data_entrega == $data_previsao) {
                            $status = "<span style='color:green;'>Entregue no prazo</span>";
                        } elseif ($data_entrega < $data_previsao) {
                            $diferenca = $data_previsao->diff($data_entrega)->days;
                            $status = "<span style='color:green;'>Entregue $diferenca dias adiantado</span>";
                        } else {
                            $diferenca = $data_entrega->diff($data_previsao)->days;
                            $status = "<span style='color:red;'>Entregue $diferenca dias atrasado</span>";
                        }
                    }

                    $dataPrev = $data_previsao ? $data_previsao->format('d/m/Y') : '---';
                    $dataEnt = $data_entrega ? $data_entrega->format('d/m/Y') : 'Não entregue';
                    ?>
                    <tr>
                        <td><?= htmlspecialchars($linha['avaliacao']) ?></td>
                        <td><?= htmlspecialchars($linha['turma']) ?></td>
                        <td><?= htmlspecialchars($linha['trimestre']) ?></td>
                        <td><?= htmlspecialchars($linha['disciplina']) ?></td>
                        <td><?= $dataPrev ?></td>
                        <td><?= $dataEnt ?></td>
                        <td><?= $status ?></td>
                        <td>
                            <button class="btn btn-primary btn-sm"
                                onclick="abrirModal(
                                    '<?= $linha['id'] ?>',
                                    '<?= htmlspecialchars($linha['avaliacao']) ?>',
                                    '<?= htmlspecialchars($linha['turma']) ?>',
                                    '<?= htmlspecialchars($linha['trimestre']) ?>',
                                    '<?= htmlspecialchars($linha['disciplina']) ?>',
                                    '<?= $dataPrev ?>',
                                    '<?= $dataEnt ?>'
                                )">
                                Detalhes
                            </button>
                        </td>
                    </tr>
                    <?php
                }
            }
            ?>
        </tbody>
    </table>
    </div>
<?php if ($totalPaginas > 1): ?>
<div class="text-center">
    <ul class="pagination">
        <?php for ($i = 1; $i <= $totalPaginas; $i++): ?>
            <li class="<?= ($i == $paginaAtual) ? 'active' : '' ?>">
                <a href="?<?= http_build_query(array_merge($_GET, ['pagina' => $i])) ?>">
                    <?= $i ?>
                </a>
            </li>
        <?php endfor; ?>
    </ul>
</div>
<?php endif; ?>

</div>

<!-- Modal -->
<div id="modalDetalhes" class="modal fade" role="dialog">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        <h4 class="modal-title">Detalhes da Entrega</h4>
      </div>
      <div class="modal-body">
        <p><strong>Avaliação:</strong> <span id="modalAvaliacao"></span></p>
        <p><strong>Turma:</strong> <span id="modalTurma"></span></p>
        <p><strong>Trimestre:</strong> <span id="modalTrimestre"></span></p>
        <p><strong>Disciplina:</strong> <span id="modalDisciplina"></span></p>
        <form id="formEntrega">
  <input type="hidden" id="inputId" name="id">

  <p><strong>Data de Previsão:</strong>
    <input type="date" id="inputDataPrevisao" name="data_previsao" class="btn-sm" required>
  </p>

  <p><strong>Status:</strong> <span id="modalStatus"></span></p>

  <p><strong>Data de Entrega:</strong>
    <input type="date" id="inputDataEntrega" name="data_entrega" class="btn-sm">
    <button type="submit" id="btnSalvar" class="btn btn-success btn-sm">Salvar alteração</button>
  </p>
</form>

      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Fechar</button>
      </div>
    </div>
  </div>
</div>

<!-- Modal Semana -->
<div id="modalSemana" class="modal fade" role="dialog">
  <div class="modal-dialog modal-lg" style="width:90%;">
    <div class="modal-content">
      <div class="modal-header bg-primary text-white">
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        <div class="d-flex justify-content-between align-items-center">
         <h4 class="modal-title" id="tituloSemana"></h4>
          <button class="btn btn-sm btn-default" onclick="carregarSemana(-1)">⏮ Semana Anterior</button>
          <button class="btn btn-sm btn-default" onclick="carregarSemana(1)">Semana Seguinte ⏭</button>
        </div>
      </div>
      <div class="modal-body" id="conteudoSemana">
        <p class="text-center">Carregando...</p>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-primary" data-dismiss="modal">Fechar</button>
      </div>
    </div>
  </div>
</div>


<script>
function abrirModal(id, avaliacao, turma, trimestre, disciplina, dataPrevisao, dataEntrega) {
    $('#inputId').val(id);
    $('#modalAvaliacao').text(avaliacao);
    $('#modalTurma').text(turma);
    $('#modalTrimestre').text(trimestre);
    $('#modalDisciplina').text(disciplina);

    // Formatar para yyyy-mm-dd
    let previsaoFormatada = converterParaInputDate(dataPrevisao);
    let entregaFormatada = converterParaInputDate(dataEntrega);

    $('#inputDataPrevisao').val(previsaoFormatada);
    $('#inputDataEntrega').val(entregaFormatada);

    // Status
    $('#modalStatus').text(dataEntrega && dataEntrega !== 'Não entregue'
        ? `Entregue em ${dataEntrega}`
        : 'Não entregue ainda');

    $('#modalDetalhes').modal('show');
}

function converterParaInputDate(dataBR) {
    if (!dataBR || dataBR === 'Não entregue') return '';
    const partes = dataBR.split('/');
    if (partes.length !== 3) return '';
    return `${partes[2]}-${partes[1]}-${partes[0]}`;
}

$('#formEntrega').submit(function(e) {
    e.preventDefault();
    $.ajax({
        url: 'salvar_entrega.php',
        type: 'POST',
        data: $(this).serialize(),
        success: function(response) {
            if (response.trim() === 'sucesso') {
                alert('Alterações salvas com sucesso!');
                location.reload();
            } else {
                alert('Erro ao salvar!');
            }
        },
        error: function() {
            alert('Erro na requisição.');
        }
    });
});

$(document).ready(function() {
    let hoje = new Date().toISOString().slice(0, 10); // pega AAAA-MM-DD
    let ultimaData = localStorage.getItem('modalSemanaData');

    if (ultimaData !== hoje) {
        $('#modalSemana').modal('show');
        localStorage.setItem('modalSemanaData', hoje);
    }
});

let semanaAtual = <?= $semana ?>;
let anoAtual = <?= $ano ?>;

function carregarSemana(direcao = 0) {
    semanaAtual += direcao;

    // controle para rollover de ano
    if (semanaAtual < 1) {
        semanaAtual = 52;
        anoAtual -= 1;
    } else if (semanaAtual > 52) {
        semanaAtual = 1;
        anoAtual += 1;
    }

    $("#conteudoSemana").html("<p class='text-center'>Carregando...</p>");
    $.get("avaliacoes_semana.php", { semana: semanaAtual, ano: anoAtual }, function (data) {
        $("#conteudoSemana").html(data);

        // Atualizar título
        let titulo = $(data).filter("h4.modal-title").text();
        $("#tituloSemana").text(titulo);
    });
}

$("#modalSemana").on("show.bs.modal", function () {
    carregarSemana(0); // carrega semana atual quando abre
});


</script>
</body>
</html>
