<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cadastro de Dispositivos</title>

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- jQuery + Mask -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.14.16/jquery.mask.min.js"></script>

    <style>
        body {
            text-transform: uppercase;
            font-size: 12px;
        }
        input[type="text"],
        input[type="date"],
        select {
            text-transform: uppercase;
            font-size: 12px;
            height: 38px; /* altura igual para todos os campos */
        }
        th, td {
            font-size: 12px;
        }
        h3 {
            font-size: 14px;
        }
        .btn-custom {
            width: 150px;
            font-size: 12px;
            border-radius: 5px;
            text-transform: uppercase;
            height: 38px;
            background-color: #000000;
        }
        .btn-container {
            gap: 20px;
        }
    </style>
</head>
<body>
    <div class="container mt-5">
        <h1 class="text-center">Cadastro de Dispositivo</h1><br>

        <form method="POST" action="inserirBd.php">
            <!-- Descrição -->
            <!-- Campos responsivos -->
            <div class="row mb-3">
                <div class="col-12 col-md-6 mb-2">
                    <label for="fabricante" class="form-label">Fabricante</label>
                    <input type="text" class="form-control" id="fabricante" name="fabricante">
                </div>
                <div class="col-12 col-md-6 mb-2">
                    <label for="modelo" class="form-label">Modelo</label>
                    <input type="text" class="form-control valor" id="modelo"  name="modelo" required>
                </div>
            </div>
            <div class="row mb-3">
                <div class="col-12 col-md-6 mb-2">
                <label for="anofabricacao" class="form-label">Ano de Fabrica&ccedil;&atilde;o</label>
                <select class="form-control" id="anofabricacao" name="anofabricacao">
                <?php
                for ($ano = 1990; $ano <= 2030; $ano++) {
                echo "<option value=\"$ano\">$ano</option>";
                 }
                ?>
                </select>
            </div>

                <div class="col-12 col-md-6 mb-2">
                    <label for="tipo" class="form-label">Tipo</label>
                    <select class="form-control" id="tipo" name="tipo">
                     <option value="Impressora (contrato digimak)">Impressora (contrato digimak)</option>
                    </select>
                </div>
            </div>
            <div class="row mb-3">
                <div class="col-12 col-md-6 mb-2">
                    <label for="localizacao" class="form-label">Localiza&ccedil;&atilde;o</label>
                    <input type="text" class="form-control" id="localizacao" name="localizacao">
                </div>
            </div>

            <!-- Botões -->
            <div class="d-flex justify-content-center btn-container mt-3 flex-wrap">
                <button type="submit" class="btn btn-dark btn-sm btn-custom">Salvar</button>
                <a href="index.php" class="btn btn-dark btn-sm btn-custom" style="padding-top: 10px;">Voltar</a>
            </div>
        </form>
    </div><br><br>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
