<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cadastro de Dispositivos</title>

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- jQuery + Mask -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.14.16/jquery.mask.min.js"></script>

    <style>
        body {
            text-transform: uppercase;
            font-size: 12px;
        }
        input[type="text"],
        input[type="date"],
        select {
            text-transform: uppercase;
            font-size: 12px;
            height: 38px; /* altura igual para todos os campos */
        }
        th, td {
            font-size: 12px;
        }
        h3 {
            font-size: 14px;
        }
        .btn-custom {
            width: 150px;
            font-size: 12px;
            border-radius: 5px;
            text-transform: uppercase;
            height: 38px;
            background-color: #000000;
        }
        .btn-container {
            gap: 20px;
        }
    </style>
</head>
<body>
    <div class="container mt-5">
        <h1 class="text-center">Cadastro de Workstation</h1><br>

        <form method="POST" action="insertBdWorkstation.php">
            <!-- Descrição -->
            <!-- Campos responsivos -->
            <div class="row mb-3">
                <div class="col-12 col-md-6 mb-2">
                    <label for="processador" class="form-label">Processador</label>
                    <input type="text" class="form-control" id="processador" name="processador">
                </div>
                <div class="col-12 col-md-6 mb-2">
                    <label for="memoria" class="form-label">Mémoria Ram</label>
                    <input type="text" class="form-control valor" id="memoria"  name="memoria" required>
                </div>
            </div>
            <div class="row mb-3">
                <div class="col-12 col-md-6 mb-2">
                    <label for="armazenamento" class="form-label">Armazenamento/Tamanho</label>
                    <input type="text" class="form-control" id="armazenamento" name="armazenamento">
                </div>
                <div class="col-12 col-md-6 mb-2">
                    <label for="gpu" class="form-label">GPU/Placa Gráfica</label>
                    <input type="text" class="form-control valor" id="gpu"  name="gpu" required>
                </div>
            </div>
            <div class="row mb-3">
                <div class="col-12 col-md-6 mb-2">
                    <label for="anofabricacao" class="form-label">Ano de Fabrica&ccedil;&atilde;o Processador</label>
                    <input type="text" class="form-control" id="anofabricacao" name="anofabricacao">
                </div>
                <div class="col-12 col-md-6 mb-2">
                    <label for="tipo" class="form-label">Tipo</label>
                    <input type="text" class="form-control valor" id="tipo"  name="tipo" value="workstation" required readonly>
                </div>
            </div>
            <div class="row mb-3">
                <div class="col-12 col-md-6 mb-2">
                    <label for="localizacao" class="form-label">Localiza&ccedil;&atilde;o do Workstation</label>
                    <input type="text" class="form-control" id="localizacao" name="localizacao">
                </div>
                <div class="col-12 col-md-6 mb-2">
                    <label for="codigo" class="form-label">C&oacute;digo </label>
                    <input type="text" class="form-control" id="codigo" name="codigo">
                </div>
            </div>

            <!-- Botões -->
            <div class="d-flex justify-content-center btn-container mt-3 flex-wrap">
                <button type="submit" class="btn btn-dark btn-sm btn-custom">Salvar</button>
                <a href="index.php" class="btn btn-dark btn-sm btn-custom" style="padding-top: 10px;">Voltar</a>
            </div>
        </form>
    </div><br><br>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
