<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Lista de E-mails</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f8f9fa;
            color: #212529;
            padding: 30px;
        }

        h2 {
            margin-bottom: 25px;
            font-weight: 600;
            color: #333;
        }

        .table-container {
            overflow-x: auto;
        }

        .table {
            background-color: #ffffff;
            box-shadow: 0 0 8px rgba(0,0,0,0.05);
            border-radius: 8px;
            overflow: hidden;
            min-width: 900px;
        }

        th {
            background-color: #212529 !important;
            color: #fff !important;
            font-size: 13px;
            text-transform: uppercase;
        }

        td, th {
            font-size: 13px;
            padding: 10px 14px !important;
            white-space: nowrap;
            vertical-align: middle;
        }

        tr:nth-child(even) {
            background-color: #f6f6f6;
        }

        tr:hover {
            background-color: #e9ecef;
        }

        .fw-bold {
            font-weight: bold;
        }

        .text-capitalize {
            text-transform: capitalize;
        }

        @media (max-width: 768px) {
            .table {
                font-size: 14px;
            }

            h2 {
                text-align: center;
                font-size: 20px;
            }
        }
    </style>
</head>
<body>

<div class="container-fluid">
    <h2>Lista de Usuários de E-mail</h2>
    <div class="table-container">
        <table class="table table-bordered table-hover table-striped table-sm">
            <thead>
                <tr>
                    <th>Usuário</th>
                    <th>Email</th>
                    <th>Status</th>
                    <th>Último Acesso</th>
                    <th>Armazenamento</th>
                    <th>Valor (USD)</th>
                    <th>Valor (BR)</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $host = 'localhost';
                $db = 'kaltekgo_avila';
                $user = 'kaltekgo_admin';
                $pass = 'kaltek@2024';

                try {
                    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8", $user, $pass);
                    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

                    $sql = "SELECT * FROM emailUsuarios";
                    $stmt = $pdo->query($sql);

                    $totalUsd = 0;
                    $totalReal = 0;

                    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                        $status = strtolower($row['status']);
                        if ($status === 'active') {
                            $statusTraduzido = 'Ativo';
                        } elseif ($status === 'suspended') {
                            $statusTraduzido = 'Suspenso';
                        } else {
                            $statusTraduzido = ucfirst($status);
                        }

                        $dataFormatada = '';
                        if (!empty($row['ultimoAcesso']) && $row['ultimoAcesso'] !== '0000-00-00') {
                            $dataFormatada = date('d/m/Y H:i', strtotime($row['ultimoAcesso']));
                        }

                        $totalUsd += (float) $row['usd'];
                        $totalReal += (float) $row['real'];

                        echo "<tr>";
                        echo "<td class='text-capitalize'>" . htmlspecialchars($row['usuarioEmail']) . "</td>";
                        echo "<td>" . htmlspecialchars($row['emailAddress']) . "</td>";
                        echo "<td>" . $statusTraduzido . "</td>";
                        echo "<td>" . $dataFormatada . "</td>";
                        echo "<td>" . htmlspecialchars($row['emailArmazenamento']) . "</td>";
                        echo "<td>$ " . number_format($row['usd'], 2, '.', ',') . "</td>";
                        echo "<td>R$ " . number_format($row['real'], 2, ',', '.') . "</td>";
                        echo "</tr>";
                    }

                    echo "<tr class='table-secondary fw-bold'>";
                    echo "<td colspan='5' class='text-end'>Total</td>";
                    echo "<td>$ " . number_format($totalUsd, 2, '.', ',') . "</td>";
                    echo "<td>R$ " . number_format($totalReal, 2, ',', '.') . "</td>";
                    echo "</tr>";
                } catch (PDOException $e) {
                    echo "<tr><td colspan='7' class='text-danger'>Erro na conexão: " . $e->getMessage() . "</td></tr>";
                }
                ?>
            </tbody>
        </table>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
