<?php
// Conexão com o banco de dados (ajuste conforme seu ambiente)
$conn = new mysqli("localhost", "kaltekgo_admin", "kaltek@2024", "kaltekgo_avila");

if ($conn->connect_error) {
    die("Erro de conexão: " . $conn->connect_error);
}

// Busca professores
$sqlProfessores = "SELECT * FROM professor_fundamental1 ORDER BY nomeProfessor";
$resultProfessores = $conn->query($sqlProfessores);

// Busca turmas
$sqlTurmas = "SELECT * 
FROM serie_turma_turno 
WHERE id_serie_turma BETWEEN 15 AND 33 
ORDER BY id_serie_turma ASC;";
$resultTurmas = $conn->query($sqlTurmas);

// Busca disciplinas
$sqldisciplina = "SELECT * FROM disciplinas_fundamental1 ORDER BY nomeDisciplina";
$resultdisciplina = $conn->query($sqldisciplina);
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="UTF-8">
  <title>Associar Professor</title>
  <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
  <style>
    body {
      font-family: Arial, sans-serif;
      background-color: #ffffff;
      margin: 20px;
      color: #000000;
    }

    .container-fluid {
      width: 100%;
    }
    
    h4, h5 {
      margin: 0 0 10px;
    }

    .btn-cadastrar, .filtro-btns {
      margin-left: 15px;
      margin-bottom: 10px;
    }

    .table-responsive-custom {
      overflow-x: auto;
      -webkit-overflow-scrolling: touch;
      margin: 0 15px 20px 15px;
      display: block;
    }

    table {
      white-space: nowrap;
      width: 100%;
      border-collapse: collapse;
      background-color: #ffffff;
      box-shadow: 0 0 10px rgba(0,0,0,0.1);
      text-transform: uppercase;
      min-width: 700px;
    }

    th, td {
      padding: 12px 15px;
      text-align: left;
      font-size: 12px;
      border: 1px solid #000;
      vertical-align: middle !important;
    }

    th {
      background-color: #000;
      color: #fff;
    }

    tr:nth-child(even) {
      background-color: #f4f4f4;
    }

    tr:hover {
      background-color: #e0e0e0;
    }

    .mensagem-erro {
      color: red;
      font-size: 11px;
      margin-top: 4px;
      display: none;
    }

    .input-error {
      border: 2px solid red !important;
      background-color: #ffe6e6;
    }
    
    @media (max-width: 768px) {
      .btn-cadastrar, .filtro-btns .btn {
        width: 100% !important;
        margin: 10px auto;
        font-size: 16px;
        height: 45px;
        padding: 10px 12px;
      }

      .form-group label,
      .form-control {
        font-size: 14px;
      }

      .form-control,
      input[type="text"],
      select {
        height: 40px;
      }

      .table-responsive-custom {
        overflow-x: auto;
        display: block;
      }

      table {
        width: 1000px;
      }

      .table th, .table td {
        min-width: 125px;
        font-size: 14px;
        padding: 8px 10px;
      }

      h4 {
        text-align: center;
      }
    }
    .form-row {
      display: flex;
      flex-wrap: wrap;
      gap: 15px;
    }
    .form-group {
      flex: 1;
      min-width: 200px;
    }
  </style>
</head>
<body>
<div class="container">
  <h3>Associar Professor, Turma e Disciplina</h3>
  <h5>Selecionar Professor, Turma e Disciplina</h5>
  <form action="inserirBd.php" method="POST" id="formSelecao">
    <div class="form-row">
      <!-- Professor -->
      <div class="form-group">
        <label for="selectProfessor">Professor:</label>
        <select id="selectProfessor" class="form-control text-uppercase" required name="id_professor">
          <option value="">Selecione um professor</option>
          <?php while ($prof = $resultProfessores->fetch_assoc()): ?>
            <option class="text-uppercase" value="<?= $prof['idProfessor'] ?>" data-nome="<?= htmlspecialchars($prof['nomeProfessor']) ?>">
              <?= htmlspecialchars($prof['nomeProfessor']) ?>
            </option>
          <?php endwhile; ?>
        </select>
        <input type="hidden" name="nomeProfessor" id="nomeProfessor">
      </div>

      <!-- Turma -->
      <div class="form-group">
        <label for="selectTurma">Turma:</label>
        <select id="selectTurma" class="form-control text-uppercase" required name="id_turma">
          <option value="">Selecione uma turma</option>
          <?php while ($turma = $resultTurmas->fetch_assoc()): ?>
            <option class="text-uppercase" value="<?= $turma['id_serie_turma'] ?>" data-turma="<?= htmlspecialchars($turma['identificador_serie'])?> - <?= htmlspecialchars($turma['identificador_turma']) ?> - <?= htmlspecialchars($turma['identificador_turno']) ?>">
              <?= htmlspecialchars($turma['identificador_serie']) ?> - 
              <?= htmlspecialchars($turma['identificador_turma']) ?> - 
              <?= htmlspecialchars($turma['identificador_turno']) ?>
            </option>
          <?php endwhile; ?>
        </select>
        <input type="hidden" name="nomeTurma" id="nomeTurma">
      </div>
      
      <!-- Disciplina -->
      <div class="form-group">
        <label for="selectDisciplina">Disciplina:</label>
        <select id="selectDisciplina" class="form-control text-uppercase" required name="id_disciplina">
          <option value="">Selecione uma disciplina</option>
          <?php while ($disciplina = $resultdisciplina->fetch_assoc()): ?>
            <option class="text-uppercase" value="<?= $disciplina['id_disciplina'] ?>" data-disciplina="<?= htmlspecialchars($disciplina['nomeDisciplina']) ?>">
              <?= htmlspecialchars($disciplina['nomeDisciplina']) ?>
            </option>
          <?php endwhile; ?>
        </select>
        <input type="hidden" name="nomeDisciplina" id="nomeDisciplina">
      </div>
    </div>
    <button type="submit" class="btn btn-success">Associar</button>
  </form>
</div>

<script>
  document.getElementById('selectProfessor').addEventListener('change', function () {
    const selectedOption = this.options[this.selectedIndex];
    const nome = selectedOption.getAttribute('data-nome') || '';
    document.getElementById('nomeProfessor').value = nome;
  });

  document.getElementById('selectDisciplina').addEventListener('change', function () {
    const selectedOption = this.options[this.selectedIndex];
    const disciplina = selectedOption.getAttribute('data-disciplina') || '';
    document.getElementById('nomeDisciplina').value = disciplina;
  });
  
  document.getElementById('selectTurma').addEventListener('change', function () {
    const selectedOption = this.options[this.selectedIndex];
    const turma = selectedOption.getAttribute('data-turma') || '';
    document.getElementById('nomeTurma').value = turma;
  });
</script>
</body>
</html>
