<?php
file_put_contents('debug_post.txt', print_r($_POST, true));
ini_set('session.gc_maxlifetime', 3600);
session_set_cookie_params(3600);
session_start();

if (!isset($_SESSION['idProfessor']) || !isset($_SESSION['nomeProfessor'])) {
    header("Location: login.php");
    exit;
}

$pdo = new PDO("mysql:host=localhost;dbname=kaltekgo_avila", "kaltekgo_admin", "kaltek@2024");
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

$tarefaInfo = null;
if (isset($_GET['idTarefa'])) {
    $stmt = $pdo->prepare("SELECT * FROM tarefas_cadastradas_fundamental1 WHERE idTarefa = ?");
    $stmt->execute([$_GET['idTarefa']]);
    $tarefaInfo = $stmt->fetch(PDO::FETCH_ASSOC);
    if (!$tarefaInfo) {
        echo "<div class='alert alert-danger'>Tarefa não encontrada.</div>";
        exit;
    }
}

// Processar formulário
if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $titulo = $_POST['tituloTarefa'];
    $id_turma = $_POST['id_turma'];
    $identificador_turma = $_POST['identificador_turma'];
    $trimestre = $_POST['id_trimestre'];
    $nome_trimestre = $_POST['nome_trimestre'];
    $id_disciplina = $_POST['idDisciplina'];
    $id_professor = $_POST['id_professor'];
    $nome_professor = $_POST['nome_professor'];
    $nome_disciplina = $_POST['nome_disciplina'];
    $data_tarefa = $_POST['data_tarefa'];
    $tipoTarefa = $_POST['tcasasala'];

    if ($tarefaInfo) {
        // Atualizar
        $stmt = $pdo->prepare("UPDATE tarefas_cadastradas_fundamental1 SET 
            tituloTarefa = :titulo,
            id_turma = :id_turma,
            identificador_turma = :identificador_turma,
            idTrimestre = :trimestre,
            nomeTrimestre = :nome_trimestre,
            idProfessor = :id_professor,
            nomeProfessor = :nome_professor,
            idDisciplina = :id_disciplina,
            nomeDisciplina = :nome_disciplina,
            data_tarefa = :data_tarefa,
            tipoTarefa = :tipoTarefa
            WHERE idTarefa = :id");

        $stmt->execute([
            ':titulo' => $titulo,
            ':id_turma' => $id_turma,
            ':identificador_turma' => $identificador_turma,
            ':trimestre' => $trimestre,
            ':nome_trimestre' => $nome_trimestre,
            ':id_professor' => $id_professor,
            ':nome_professor' => $nome_professor,
            ':id_disciplina' => $id_disciplina,
            ':nome_disciplina' => $nome_disciplina,
            ':data_tarefa' => $data_tarefa,
            ':tipoTarefa' => $tipoTarefa,
            ':id' => $_GET['idTarefa']
        ]);
        echo "<div class='alert alert-success text-center' id='mensagem'>Tarefa atualizada com sucesso!</div>";
    } else {
        // Gerar NT
        $stmtContador = $pdo->prepare("SELECT COUNT(*) FROM tarefas_cadastradas_fundamental1 
            WHERE id_turma = :id_turma 
            AND idProfessor = :id_professor 
            AND idDisciplina = :id_disciplina 
            AND nomeTrimestre = :nome_trimestre");
        $stmtContador->execute([
            ':id_turma' => $id_turma,
            ':id_professor' => $id_professor,
            ':id_disciplina' => $id_disciplina,
            ':nome_trimestre' => $nome_trimestre
        ]);
        $contador = $stmtContador->fetchColumn();
        $NT = 'NT' . ($contador + 1);

        $stmt = $pdo->prepare("INSERT INTO tarefas_cadastradas_fundamental1 
            (identificadorTarefa, tituloTarefa, id_turma, identificador_turma, idTrimestre, nomeTrimestre, idProfessor, nomeProfessor, idDisciplina, nomeDisciplina, data_tarefa, tipoTarefa)
            VALUES (:nt, :titulo, :id_turma, :identificador_turma, :trimestre, :nome_trimestre, :id_professor, :nome_professor, :id_disciplina, :nome_disciplina, :data_tarefa, :tipoTarefa)");

        $stmt->execute([
            ':nt' => $NT,
            ':titulo' => $titulo,
            ':id_turma' => $id_turma,
            ':identificador_turma' => $identificador_turma,
            ':trimestre' => $trimestre,
            ':nome_trimestre' => $nome_trimestre,
            ':id_professor' => $id_professor,
            ':nome_professor' => $nome_professor,
            ':id_disciplina' => $id_disciplina,
            ':nome_disciplina' => $nome_disciplina,
            ':data_tarefa' => $data_tarefa,
            ':tipoTarefa' => $tipoTarefa
        ]);
        echo "<div class='alert alert-success text-center' id='mensagem'>Tarefa cadastrada com sucesso!</div>";
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Editar Tarefa</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
</head>
<body style="background-color: #ffffff;" class="text-uppercase">
<div class="container">
    <div class="row" style="margin-top: 60px;">
        <div class="col-md-8 col-md-offset-2">
            <div class="panel panel-default">
                <div class="text-center">
                    <h3><?= $tarefaInfo ? 'Editar Tarefa' : 'Cadastrar Tarefa' ?></h3>
                </div>
                <div class="panel-body">
                    <form method="post" action="salvarEditarTarefa.php">
    <!-- Título da Tarefa -->
    <div class="form-group">
        <label for="tituloTarefa">Título da Tarefa</label>
        <input type="text" name="tituloTarefa" id="tituloTarefa" class="form-control text-uppercase" required
               value="<?= htmlspecialchars($tarefaInfo['tituloTarefa']) ?>">
    </div>

    <!-- Turma (desabilitado para edição, mas enviado como hidden) -->
    <div class="form-group">
        <label>Turma</label>
        <input type="text" class="form-control text-uppercase" value="<?= htmlspecialchars($tarefaInfo['identificador_turma']) ?>" disabled>
        <input type="hidden" name="id_turma" value="<?= $tarefaInfo['id_turma'] ?>">
        <input type="hidden" name="identificador_turma" value="<?= htmlspecialchars($tarefaInfo['identificador_turma']) ?>">
    </div>

    <!-- Trimestre -->
    <div class="form-group">
        <label>Trimestre</label>
        <input type="text" class="form-control text-uppercase" value="<?= htmlspecialchars($tarefaInfo['nomeTrimestre']) ?>" disabled>
        <input type="hidden" name="id_trimestre" value="<?= $tarefaInfo['idTrimestre'] ?>">
        <input type="hidden" name="nome_trimestre" value="<?= htmlspecialchars($tarefaInfo['nomeTrimestre']) ?>">
    </div>

    <!-- Disciplina -->
    <div class="form-group">
        <label>Disciplina</label>
        <input type="text" class="form-control text-uppercase" value="<?= htmlspecialchars($tarefaInfo['nomeDisciplina']) ?>" disabled>
        <input type="hidden" name="idDisciplina" value="<?= $tarefaInfo['idDisciplina'] ?>">
        <input type="hidden" name="nome_disciplina" value="<?= htmlspecialchars($tarefaInfo['nomeDisciplina']) ?>">
    </div>

    <!-- Professor -->
    <div class="form-group">
        <label>Professor</label>
        <input type="text" class="form-control text-uppercase" value="<?= htmlspecialchars($tarefaInfo['nomeProfessor']) ?>" disabled>
        <input type="hidden" name="id_professor" value="<?= $tarefaInfo['idProfessor'] ?>">
        <input type="hidden" name="nome_professor" value="<?= htmlspecialchars($tarefaInfo['nomeProfessor']) ?>">
    </div>

    <!-- Data da Tarefa -->
    <div class="form-group">
        <label for="data_tarefa">Data da Tarefa</label>
        <input type="date" name="data_tarefa" id="data_tarefa" class="form-control" required
               value="<?= date('Y-m-d', strtotime($tarefaInfo['data_tarefa'])) ?>">
    </div>

    <!-- Tipo de Tarefa -->
    <div class="form-group">
        <label for="tcasasala">Tarefa Casa / Tarefa Sala</label>
        <select name="tcasasala" id="tcasasala" class="form-control text-uppercase" required>
            <option value="">Escolha uma opção</option>
            <option value="Tarefa Casa" <?= $tarefaInfo['tipoTarefa'] === 'Tarefa Casa' ? 'selected' : '' ?>>Tarefa Casa</option>
            <option value="Tarefa Sala" <?= $tarefaInfo['tipoTarefa'] === 'Tarefa Sala' ? 'selected' : '' ?>>Tarefa Sala</option>
        </select>
    </div>

    <!-- Botão -->
    <input type="hidden" name="idTarefa" value="<?= $tarefaInfo['idTarefa'] ?>">
    <button type="submit" class="btn btn-danger btn-block">Salvar Alterações</button>
    <a href="https://avilagoiania.kaltekgoiania.com.br/fundamental1/index.php" class="btn btn-default btn-block" style="margin-top: 10px;">Voltar</a>
</form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.getElementById('id_turma').addEventListener('change', function () {
    const turmaId = this.value;
    const nomeTurma = this.options[this.selectedIndex].dataset.nome;
    document.getElementById('identificador_turma').value = nomeTurma;

    const xhr = new XMLHttpRequest();
    xhr.open("GET", "buscar_disciplinas.php?id_turma=" + turmaId, true);
    xhr.onload = function () {
        if (xhr.status === 200) {
            const select = document.getElementById('idDisciplina');
            select.innerHTML = '<option value="">Selecione a disciplina</option>' + xhr.responseText;
            document.getElementById('nomeDisciplina').value = '';
        }
    };
    xhr.send();
});

document.getElementById('idDisciplina').addEventListener('change', function () {
    const nome = this.options[this.selectedIndex].dataset.nome;
    document.getElementById('nome_disciplina').value = nome;
});

window.onload = function () {
    const turmaSelecionada = document.getElementById('id_turma').selectedOptions[0];
    if (turmaSelecionada) {
        document.getElementById('identificador_turma').value = turmaSelecionada.dataset.nome;
    }
    const disciplinaSelecionada = document.getElementById('idDisciplina').selectedOptions[0];
    if (disciplinaSelecionada) {
        document.getElementById('nomeDisciplina').value = disciplinaSelecionada.dataset.nome;
    }
};

setTimeout(function () {
    const msg = document.getElementById('mensagem');
    if (msg) msg.style.display = 'none';
}, 3000);
</script>
</body>
</html>
