<?php
session_start();

require_once "conexao.php"; // conexão já deve definir $conn

if (isset($_GET['tarefa'], $_GET['turma'], $_GET['disciplina'])) {
    $tarefa = $_GET['tarefa'];
    $turma = $_GET['turma'];
    $disciplina = $_GET['disciplina'];

    // Recupera o professor e trimestre da sessão
    $idProfessor = $_SESSION['idProfessor'] ?? null;
    $trimestre = $_SESSION['trimestre'] ?? null;
    $tipo = $_SESSION['tipoUsuario'] ?? null;

    if (!$trimestre) {
        echo "<div class='alert alert-danger'>Sessão expirada ou incompleta.</div>";
        exit;
    }

    // Verifica se o tipo de usuário pode ver todas as tarefas (sem filtrar por professor)
    if ($tipo === 'admin' || $tipo === 'coordenador') {
        $sql = "SELECT * FROM tarefas_cadastradas_fundamental1 
                WHERE id_turma = ? 
                  AND identificadorTarefa = ? 
                  AND idDisciplina = ? 
                  AND nomeTrimestre = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("isis", $turma, $tarefa, $disciplina, $trimestre);
    } else {
        // Filtra também pelo professor
        if (!$idProfessor) {
            echo "<div class='alert alert-danger'>Sessão expirada ou incompleta.</div>";
            exit;
        }
        $sql = "SELECT * FROM tarefas_cadastradas_fundamental1 
                WHERE id_turma = ? 
                  AND identificadorTarefa = ? 
                  AND idProfessor = ? 
                  AND idDisciplina = ? 
                  AND nomeTrimestre = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("isiss", $turma, $tarefa, $idProfessor, $disciplina, $trimestre);
    }

    if (!$stmt) {
        echo "<div class='alert alert-danger'>Erro na preparação da consulta.</div>";
        exit;
    }

    $stmt->execute();
    $resultado = $stmt->get_result();

    if ($resultado->num_rows > 0) {
        $tarefaInfo = $resultado->fetch_assoc();
        echo "<p>Tarefa: <strong>{$tarefaInfo['tituloTarefa']}</strong></p>";
        echo "<p>Professor(a): <strong>{$tarefaInfo['nomeProfessor']}</strong></p>";
        echo "<p>Disciplina: <strong>{$tarefaInfo['nomeDisciplina']}</strong></p>";
        echo "<p>Trimestre: <strong>{$tarefaInfo['nomeTrimestre']}</strong></p>";
        $data = date('d/m/Y', strtotime($tarefaInfo['data_tarefa']));
        echo "<p>Data da Tarefa: <strong>{$data}</strong></p>";
        echo "<p>Tipo Tarefa: <strong>{$tarefaInfo['tipoTarefa']}</strong></p>";
        echo "<form action='editarTarefa.php' method='GET' id='form1'>";
        echo "<input type='hidden' name='idTarefa' value='{$tarefaInfo['idTarefa']}'>";
        echo "<button class='btn btn-danger' type='submit'>Editar Tarefa</button>";
        echo "</form>";
    } else {
        echo "<div class='alert alert-warning'>Nenhuma informação encontrada para a tarefa selecionada.</div>";
    }

    $stmt->close();
} else {
    echo "<div class='alert alert-danger'>Parâmetros inválidos.</div>";
}
?>
