<?php
require 'conexao.php';

$termo = isset($_POST['termo']) ? trim($_POST['termo']) : '';

if ($termo === '') {
    echo '<div class="alert alert-warning">Digite um termo para buscar.</div>';
    exit;
}

$sql = "SELECT * FROM nota_tarefas_entregues WHERE nome LIKE :termo ORDER BY nome";
$stmt = $pdo->prepare($sql);
$stmt->execute([':termo' => "%$termo%"]);
$alunos = $stmt->fetchAll(PDO::FETCH_ASSOC);

if (count($alunos) === 0) {
    echo '<div class="alert alert-info">Nenhum aluno encontrado.</div>';
    exit;
}

// Identifica colunas t1, t2, t3, ... que têm valores
$colunas_nt = [];
foreach (['t1', 't2', 't3', 't4', 't5'] as $coluna) {
    foreach ($alunos as $aluno) {
        if (!empty($aluno[$coluna])) {
            $colunas_nt[] = $coluna;
            break;
        }
    }
}

echo '<table class="table table-bordered table-striped">';
echo '<thead><tr>';

// Cabeçalhos fixos
echo '<th>Matrícula</th>';
echo '<th>Nome Aluno</th>';

// Cabeçalhos dinâmicos com classe clicável
foreach ($colunas_nt as $coluna) {
    echo '<th class="coluna-info" data-coluna="' . $coluna . '">' . strtoupper($coluna) . '</th>';
}

echo '</tr></thead><tbody>';

// Linhas de dados
foreach ($alunos as $aluno) {
    echo '<tr>';
    echo '<td>' . htmlspecialchars($aluno['matricula']) . '</td>';
    echo '<td>' . htmlspecialchars($aluno['nome']) . '</td>';
    foreach ($colunas_nt as $coluna) {
        echo '<td>' . htmlspecialchars($aluno[$coluna]) . '</td>';
    }
    echo '</tr>';
}

echo '</tbody></table>';
?>
