<?php
session_start();

$tipo = $_SESSION['tipoUsuario'] ?? '';

if (empty($tipo)) {
    // Se o tipo no estiver definido, retorna 0
    echo json_encode(['total' => 0]);
    exit;
}

try {
    $pdo = new PDO("mysql:host=localhost;dbname=kaltekgo_avila", "kaltekgo_admin", "kaltek@2024");
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $id_turma = $_GET['id_turma'] ?? null;
    $id_disciplina = $_GET['id_disciplina'] ?? null;
    $trimestre = $_GET['trimestre'] ?? 2;

    $totalTarefas = 0;

    if ($id_turma && $id_disciplina) {
        if ($tipo === 'admin' || $tipo === 'coordenador') {
            // Consulta sem filtrar por professor
            $stmt = $pdo->prepare("
                SELECT COUNT(*) AS total_tarefas
                FROM tarefas_cadastradas
                WHERE id_turma = :turma 
                  AND idDisciplina = :disciplina 
                  AND idTrimestre = :trimestre
            ");
            $stmt->execute([
                ':turma' => $id_turma,
                ':disciplina' => $id_disciplina,
                ':trimestre' => $trimestre
            ]);
            $resultado = $stmt->fetch(PDO::FETCH_ASSOC);
            $totalTarefas = $resultado['total_tarefas'] ?? 0;
        } 
        // Aqui voc pode colocar lgica para professor, se desejar
        // else if ($tipo === 'professor') { ... }
    }

    echo json_encode(['total' => $totalTarefas]);

} catch (PDOException $e) {
    // Retorna erro como JSON para facilitar debug
    echo json_encode(['error' => $e->getMessage()]);
}
?>
