<?php

// Define duração da sessão (4 horas = 14400 segundos)
ini_set('session.gc_maxlifetime', 14400);
session_set_cookie_params(14400);
session_start();

// Você pode usar a data atual ou passar uma data específica
$data = date('Y-m-d'); // data atual
// $data = '2025-07-01'; // Exemplo de data fixa

// Converte a data em timestamp
$timestamp = strtotime($data);

// Obtém o mês e o dia
$mes = (int)date('m', $timestamp);
$dia = (int)date('d', $timestamp);

// Determina o trimestre
if (($mes == 1) || ($mes == 2) || ($mes == 3) || ($mes == 4)) {
    $trimestre = "1º Trimestre";
} elseif (($mes == 5) || ($mes == 6) || ($mes == 7) || ($mes == 8)) {
    $trimestre = "2º Trimestre";
} else {
    $trimestre = "3º Trimestre";
}

// Abertura das sessões 
$_SESSION['login_time'] = time();
$_SESSION['session_duration'] = 14400; // 4 horas
$_SESSION['trimestre'] = $trimestre;

// Conexão com o banco de dados
$host = "localhost";
$usuario_db = "kaltekgo_admin";
$senha_db = "kaltek@2024";
$banco = "kaltekgo_avila";

$conn = new mysqli($host, $usuario_db, $senha_db, $banco);
if ($conn->connect_error) {
    die("Erro de conexão: " . $conn->connect_error);
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $login = $_POST['login'];
    $senha = $_POST['senha'];

    $stmt = $conn->prepare("SELECT * FROM users WHERE login = ? AND senha = ?");
    $stmt->bind_param("ss", $login, $senha);
    $stmt->execute();
    $resultado = $stmt->get_result();

    if ($resultado->num_rows === 1) {
        $dados = $resultado->fetch_assoc();
        $_SESSION['login'] = $dados['login'];
        $_SESSION['nome_usuario'] = $dados['nome_usuario'];
        $_SESSION['tipoUsuario'] = $dados['tipoUsuario'];

        header("Location: dashboard.php");
        exit;
    } else {
        // Login inválido - pode redirecionar ou exibir mensagem
        header("Location: login.php?erro=1");
        exit;
    }
}

$conn->close();
?>
