<?php
require_once 'vendor/autoload.php'; // Certifique-se de que o Dompdf esteja instalado via Composer

use Dompdf\Dompdf;
use Dompdf\Options;

// ==== Conexão com o banco (PDO) ====
$host = "localhost";
$user = "kaltekgo_admin";       
$pass = "kaltek@2024";          
$db   = "kaltekgo_avila";       

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Erro na conexão: " . $e->getMessage());
}

// ==== Consulta unindo alunos com notas ====
$sql = "SELECT 
            a.matricula,
            a.nome,
            a.identificadorturma,
            n.enem_dia1,
            n.enem_dia2,
            n.redacao,
            n.media
        FROM alunos_confirmados_2025 a
        LEFT JOIN notas_enemfit_2025 n ON a.matricula = n.matricula
        WHERE a.identificadorturma = '1º ANO  - M (2025)'
        ORDER BY a.nome ASC";

$stmt = $pdo->query($sql);
$alunos = $stmt->fetchAll(PDO::FETCH_ASSOC);

// ==== Monta o HTML do relatório ====
$html = '
<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="UTF-8">
<title>ENEMFIT</title>
<style>
body {
    background-color: #fff;
    color: #000;
    font-family: Arial, sans-serif;
    font-size: 12px;
    margin: 20px;
}
h3 {
    text-align: center;
    font-weight: bold;
    margin-bottom: 20px;
}
.logo {
    width: 120px;
    float: right;
}
table {
    width: 100%;
    border-collapse: collapse;
    margin-top: 30px;
}
th, td {
    border: 1px solid #000;
    padding: 6px;
    text-align: center;
}
th {
    background-color: #000;
    color: #fff;
}
tr:nth-child(even) { background-color: #f9f9f9; }
.media {
    background-color: #f3f3f3;
}
</style>
</head>
<body>
<img src="https://colegioavila.com.br/wp-content/uploads/2018/11/logo-com-sombra2.png" class="logo">
<h3>ENEMFIT - 3º TRIMESTRE</h3>
<table>
<thead>
<tr>
    <th>MATRÍCULA</th>
    <th>NOME</th>
    <th>TURMA</th>
    <th>ED1</th>
    <th>ED2</th>
    <th>RE</th>
    <th>MÉDIA</th>
</tr>
</thead>
<tbody>';

if (count($alunos) > 0) {
    foreach ($alunos as $a) {
        $valores = array_map('floatval', [
            $a['enem_dia1'],
            $a['enem_dia2'],
            $a['redacao']
        ]);

        $validos = array_filter($valores, function($v) {
            return is_numeric($v) && $v > 0;
        });

        $media = count($validos) > 0 ? (array_sum($validos) / 3) : '';

        $html .= '<tr>
            <td>' . htmlspecialchars($a['matricula']) . '</td>
            <td>' . htmlspecialchars($a['nome']) . '</td>
            <td>' . htmlspecialchars($a['identificadorturma']) . '</td>
            <td>' . htmlspecialchars($a['enem_dia1']) . '</td>
            <td>' . htmlspecialchars($a['enem_dia2']) . '</td>
            <td>' . htmlspecialchars($a['redacao']) . '</td>
            <td class="media">' . ($media !== '' ? number_format($media, 2, ',', '') : '-') . '</td>
        </tr>';
    }
} else {
    $html .= '<tr><td colspan="7" style="text-align:center; color:red;">Nenhum aluno encontrado.</td></tr>';
}

$html .= '
</tbody>
</table>
</body>
</html>';

// ==== Gera o PDF ====
$options = new Options();
$options->set('isHtml5ParserEnabled', true);
$options->set('isRemoteEnabled', true); // Permite carregar a logo externa

$dompdf = new Dompdf($options);
$dompdf->loadHtml($html);
$dompdf->setPaper('A4', 'portrait');
$dompdf->render();

// Exibe o PDF no navegador (sem baixar)
$dompdf->stream('Media_ENEMFIT.pdf', ['Attachment' => false]);
exit;
