<?php
$servername = "localhost";
$username = "kaltekgo_admin";
$password = "kaltek@2024";
$dbname = "kaltekgo_avila";

// Criar conexão
$conn = new mysqli($servername, $username, $password, $dbname);

// Verificar conexão
if ($conn->connect_error) {
    die("FALHA NA CONEXÃO: " . $conn->connect_error);
}

// Consulta para obter os dados do gráfico
$sql = "SELECT * FROM simulado_ensinoMedio_evolucional_ciclo1";
$result = $conn->query($sql);

$aluno = [];
$notas = [];
$C1 = [];
$C2 = [];
$C3 = [];
$C4 = [];
$C5 = [];

if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $aluno[] = strtoupper($row['aluno']);
        $notas[] = $row['nota'];
        $C1[] = $row['C1'];
        $C2[] = $row['C2'];
        $C3[] = $row['C3'];
        $C4[] = $row['C4'];
        $C5[] = $row['C5'];
    }
}
$conn->close();
?>
<!DOCTYPE html>
<html lang="PT-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>GRÁFICOS COM CHART.JS</title>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <style>
        body {
            text-align: center;
            padding: 50px;
        }
        h2 {
            text-transform: uppercase;
        }
    </style>
</head>
<body>
    <h2>DESEMPENHO POR ALUNO</h2>
    <canvas id="graficoNotas"></canvas>

    <script>
        const ctxNotas = document.getElementById('graficoNotas').getContext('2d');
        new Chart(ctxNotas, {
            type: 'bar',
            data: {
                labels: <?php echo json_encode($aluno); ?>,
                datasets: [{
                    label: 'NOTAS',
                    data: <?php echo json_encode($notas); ?>,
                    backgroundColor: 'rgba(54, 162, 235, 0.5)',
                    borderColor: 'rgba(54, 162, 235, 1)',
                    borderWidth: 1,
                }]
            },
            options: {
                responsive: true,
                scales: {
                    y: { beginAtZero: true }
                }
            }
        });
    </script>

    <?php 
    $categorias = ['C1', 'C2', 'C3', 'C4', 'C5'];
    foreach ($categorias as $indice => $categoria) { ?>
        <h2>DESEMPENHO <?php echo $categoria; ?></h2>
        <canvas id="grafico<?php echo $categoria; ?>"></canvas>
        <script>
            const ctx<?php echo $categoria; ?> = document.getElementById('grafico<?php echo $categoria; ?>').getContext('2d');
            new Chart(ctx<?php echo $categoria; ?>, {
                type: 'bar',
                data: {
                    labels: <?php echo json_encode($aluno); ?>,
                    datasets: [{
                        label: '<?php echo strtoupper($categoria); ?>',
                        data: <?php echo json_encode($$categoria); ?>,
                        backgroundColor: 'rgba(255, 99, 132, 0.5)',
                        borderColor: 'rgba(255, 99, 132, 1)',
                        borderWidth: 1
                    }]
                },
                options: {
                    responsive: true,
                    scales: {
                        y: { beginAtZero: true }
                    }
                }
            });
        </script>
    <?php } ?>
</body>
</html>
