<?php
$servername = "localhost";
$username = "kaltekgo_admin";
$password = "kaltek@2024";
$dbname = "kaltekgo_avila";

// Criando conexão
$conn = new mysqli($servername, $username, $password, $dbname);

// Checando conexão
if ($conn->connect_error) {
    die("Conexão falhou: " . $conn->connect_error);
}

// Buscar a maior e menor nota diferente de 0
$sql_min_max = "SELECT MIN(nota) as min_nota, MAX(nota) as max_nota FROM simulado_ensinoMedio_evolucional_ciclo1 WHERE nota > 0";
$result_min_max = $conn->query($sql_min_max);
$row_min_max = $result_min_max->fetch_assoc();
$min_nota = $row_min_max['min_nota'];
$max_nota = $row_min_max['max_nota'];

$sql = "SELECT * FROM simulado_ensinoMedio_evolucional_ciclo1 ORDER BY aluno ASC";
$result = $conn->query($sql);
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Redação</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        table td, th {
            text-transform: uppercase;
            font-size: 12px;
            text-align: center;
            width: 100px;
            white-space: nowrap;
        }
        .nota-max {
            background-color: #7be0a6 !important; /* Verde */
            color: black;
        }
        .nota-min {
            background-color: #fdfd96 !important; /* Amarelo pastel */
            color: black;
        }
        .nota-zero {
            background-color: #ff6961 !important; /* Vermelho */
            color: white;
        }
        h3, h5{
            text-align: left;
        }
    </style>
</head>
<body>
    <div class="container mt-4">
        <h3 class="mb-3">Resultados da Redação</h3>
        <h5>Legenda</h5>
        <h5>Verde: Maior Nota / Amarelo: Menor Nota / Vermelho: Nota inexistente ou em Correção</h5>
        <table class="table table-striped table-bordered">
            <thead class="table-dark">
                <tr>
                    <th>RA</th>
                    <th>RE</th>
                    <th>ALUNO</th>
                    <th>TURMA</th>
                    <th>NOTA</th>
                    <th>C1</th>
                    <th>C2</th>
                    <th>C3</th>
                    <th>C4</th>
                    <th>C5</th>
                    <th>MOTIVO DA ANULAÇÃO</th>
                </tr>
            </thead>
            <tbody>
                <?php
                if ($result->num_rows > 0) {
                    while ($row = $result->fetch_assoc()) {
                        $nota_class = "";
                        if ($row["nota"] == $max_nota) {
                            $nota_class = "nota-max";
                        } elseif ($row["nota"] == 0) {
                            $nota_class = "nota-zero";
                        } elseif ($row["nota"] == $min_nota) {
                            $nota_class = "nota-min";
                        }

                        echo "<tr>";
                        echo "<td >" . strtoupper($row["RA"]) . "</td>";
                        echo "<td>" . strtoupper($row["RE"]) . "</td>";
                        echo "<td style='text-align: left;'>" . strtoupper($row["aluno"]) . "</td>";
                        echo "<td>" . strtoupper($row["turma"]) . "</td>";
                        echo "<td class='$nota_class'>" . strtoupper($row["nota"]) . "</td>";
                        echo "<td>" . strtoupper($row["C1"]) . "</td>";
                        echo "<td>" . strtoupper($row["C2"]) . "</td>";
                        echo "<td>" . strtoupper($row["C3"]) . "</td>";
                        echo "<td>" . strtoupper($row["C4"]) . "</td>";
                        echo "<td>" . strtoupper($row["C5"]) . "</td>";
                        echo "<td>" . ($row["motivodeanulacao"] == "0" ? "NÃO ANULADA<br>EM CORREÇÃO" : ($row["motivodeanulacao"] == "1" ? "CORRIGIDA" : "ANULADA<br>" . strtoupper($row["motivodeanulacao"]))) . "</td>";

                        echo "</tr>";
                    }
                } else {
                    echo "<tr><td colspan='11' class='text-center'>Nenhum registro encontrado</td></tr>";
                }
                ?>
            </tbody>
        </table>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>

<?php
$conn->close();
?>

<?php
$servername = "localhost";
$username = "kaltekgo_admin";
$password = "kaltek@2024";
$dbname = "kaltekgo_avila";

// Criar conexão
$conn = new mysqli($servername, $username, $password, $dbname);

// Verificar conexão
if ($conn->connect_error) {
    die("FALHA NA CONEXÃO: " . $conn->connect_error);
}

// Consulta para obter os dados do gráfico
$sql = "SELECT * FROM simulado_ensinoMedio_evolucional_ciclo1";
$result = $conn->query($sql);

$aluno = [];
$notas = [];
$C1 = [];
$C2 = [];
$C3 = [];
$C4 = [];
$C5 = [];

if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $aluno[] = strtoupper($row['aluno']);
        $notas[] = $row['nota'];
        $C1[] = $row['C1'];
        $C2[] = $row['C2'];
        $C3[] = $row['C3'];
        $C4[] = $row['C4'];
        $C5[] = $row['C5'];
    }
}
$conn->close();
?>
<!DOCTYPE html>
<html lang="PT-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>GRÁFICOS COM CHART.JS</title>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <style>
        .grafico {
            text-align: center;
            padding-left:100px;
            padding-right:100px;
        }
        h2 {
            text-transform: uppercase;
            
        }
    </style>
</head>
<body class="grafico">
    <h2>DESEMPENHO POR ALUNO</h2>
    <canvas id="graficoNotas"></canvas>

    <script>
        const ctxNotas = document.getElementById('graficoNotas').getContext('2d');
        new Chart(ctxNotas, {
            type: 'bar',
            data: {
                labels: <?php echo json_encode($aluno); ?>,
                datasets: [{
                    label: 'NOTAS',
                    data: <?php echo json_encode($notas); ?>,
                    backgroundColor: 'rgba(54, 162, 235, 0.5)',
                    borderColor: 'rgba(54, 162, 235, 1)',
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                scales: {
                    y: { beginAtZero: true }
                }
            }
        });
    </script>

    <?php 
    $categorias = ['C1', 'C2', 'C3', 'C4', 'C5'];
    foreach ($categorias as $indice => $categoria) { ?>
        <h2>DESEMPENHO <?php echo $categoria; ?></h2>
        <canvas id="grafico<?php echo $categoria; ?>"></canvas>
        <script>
            const ctx<?php echo $categoria; ?> = document.getElementById('grafico<?php echo $categoria; ?>').getContext('2d');
            new Chart(ctx<?php echo $categoria; ?>, {
                type: 'bar',
                data: {
                    labels: <?php echo json_encode($aluno); ?>,
                    datasets: [{
                        label: '<?php echo strtoupper($categoria); ?>',
                        data: <?php echo json_encode($$categoria); ?>,
                        backgroundColor: 'rgba(255, 99, 132, 0.5)',
                        borderColor: 'rgba(255, 99, 132, 1)',
                        borderWidth: 1
                    }]
                },
                options: {
                    responsive: true,
                    scales: {
                        y: { beginAtZero: true }
                    }
                }
            });
        </script>
    <?php } ?>
</body>
</html>
