<?php
require 'vendor/autoload.php';

use Dompdf\Dompdf;
use Dompdf\Options;

$servername = "localhost";
$username = "kaltekgo_admin";
$password = "kaltek@2024";
$dbname = "kaltekgo_avila";

// Criando conexão
$conn = new mysqli($servername, $username, $password, $dbname);

// Checando conexão
if ($conn->connect_error) {
    die("Conexão falhou: " . $conn->connect_error);
}

// Buscar a maior e menor nota diferente de 0
$sql_min_max = "SELECT MIN(nota) as min_nota, MAX(nota) as max_nota FROM simulado_ensinoMedio_evolucional_ciclo1 WHERE nota > 0";
$result_min_max = $conn->query($sql_min_max);
$row_min_max = $result_min_max->fetch_assoc();
$min_nota = $row_min_max['min_nota'];
$max_nota = $row_min_max['max_nota'];

$sql = "SELECT * FROM simulado_ensinoMedio_evolucional_ciclo1 ORDER BY aluno ASC";
$result = $conn->query($sql);

$html = '
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Redação</title>
    <style>
    table {
        width: 100%; /* Preencher a largura da página */
        table-layout: auto; /* Ajuste automático da largura */
    }
    table, th, td {
        border: 1px solid black;
        border-collapse: collapse;
        text-transform: uppercase;
        font-size: 12px;
        text-align: center;
        padding: 4px;
    }
    .nota-max {
        background-color: #7be0a6;
        color: black;
    }
    .nota-min {
        background-color: #fdfd96;
        color: black;
    }
    .nota-zero {
        background-color: #ff6961;
        color: white;
    }
    h3, h5 {
        text-align: left;
    }
</style>

</head>
<body>
    <div>
        <h3>Resultados da Redação Ciclo 1 - Evolucional</h3>
        <h5>Legenda</h5>
        <h5>Verde: Maior Nota / Amarelo: Menor Nota / Vermelho: Nota inexistente ou em Correção</h5>
        <table>
            <thead>
                <tr>
                    <th>RA</th>
                    <th>RE</th>
                    <th>ALUNO</th>
                    <th>TURMA</th>
                    <th>NOTA</th>
                    <th>C1</th>
                    <th>C2</th>
                    <th>C3</th>
                    <th>C4</th>
                    <th>C5</th>
                    <th>MOTIVO DA ANULAÇÃO</th>
                </tr>
            </thead>
            <tbody>';

if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $nota_class = "";
        if ($row["nota"] == $max_nota) {
            $nota_class = "nota-max";
        } elseif ($row["nota"] == 0) {
            $nota_class = "nota-zero";
        } elseif ($row["nota"] == $min_nota) {
            $nota_class = "nota-min";
        }

        $html .= "<tr>";
        $html .= "<td>" . strtoupper($row["RA"]) . "</td>";
        $html .= "<td>" . strtoupper($row["RE"]) . "</td>";
        $html .= "<td style='text-align: left;'>" . strtoupper($row["aluno"]) . "</td>";
        $html .= "<td>" . strtoupper($row["turma"]) . "</td>";
        $html .= "<td class='$nota_class'>" . strtoupper($row["nota"]) . "</td>";
        $html .= "<td>" . strtoupper($row["C1"]) . "</td>";
        $html .= "<td>" . strtoupper($row["C2"]) . "</td>";
        $html .= "<td>" . strtoupper($row["C3"]) . "</td>";
        $html .= "<td>" . strtoupper($row["C4"]) . "</td>";
        $html .= "<td>" . strtoupper($row["C5"]) . "</td>";
        $html .= "<td>" . ($row["motivodeanulacao"] == "0" ? "NÃO ANULADA<br>EM CORREÇÃO" : ($row["motivodeanulacao"] == "1" ? "CORRIGIDA" : "ANULADA<br>" . strtoupper($row["motivodeanulacao"]))) . "</td>";
        $html .= "</tr>";
    }
} else {
    $html .= "<tr><td colspan='11' style='text-align: center;'>Nenhum registro encontrado</td></tr>";
}

$html .= '
            </tbody>
        </table>
    </div>
</body>
</html>';

// Instanciando o DOMPDF com opções
$options = new Options();
$options->set('isHtml5ParserEnabled', true);
$options->set('isRemoteEnabled', true);
$dompdf = new Dompdf($options);

// Carregando o conteúdo HTML
$dompdf->loadHtml($html);

// Definindo o tamanho do papel e a orientação
$dompdf->setPaper('A4', 'landscape');

// Renderizando o PDF
$dompdf->render();

// Enviando o PDF para o navegador
$dompdf->stream("redacao_resultados.pdf", ["Attachment" => false]);
?>
