<?php
// Configurações de conexão com o banco de dados
$host = 'localhost'; // Endereço do servidor
$user = 'kaltekgo_admin'; // Usuário do banco de dados
$password = 'kaltek@2024'; // Senha do banco de dados
$dbname = 'kaltekgo_avila'; // Nome do banco de dados

try {
    // Conexão com o banco de dados usando PDO
    $conn = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $user, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Captura os dados enviados pelo formulário
    $nomeAluno = $_POST['nomeAluno'] ?? '';
    $emailAluno = $_POST['emailAluno'] ?? '';
    $telefoneAluno = $_POST['telefoneAluno'] ?? '';
    $nomeResponsavel = $_POST['nomeResponsavel'] ?? '';
    $emailResponsavel = $_POST['emailResponsavel'] ?? '';
    $telefoneResponsavel = $_POST['telefoneResponsavel'] ?? '';
    $serieTurmaTurno = $_POST['serieTurmaTurno'] ?? '';

    // Validação dos campos vazios
    if (empty($emailAluno) || empty($emailResponsavel) || empty($telefoneAluno) || empty($telefoneResponsavel)) {
        echo "<script>
                alert('Os campos de email e telefone não podem estar vazios!');
                window.history.back();
              </script>";
        exit;
    }

    // Validação dos emails serem diferentes
    if ($emailAluno === $emailResponsavel) {
        echo "<script>
                alert('Os emails do aluno e do responsável não podem ser iguais!');
                window.history.back();
              </script>";
        exit;
    }

    // Validação dos telefones serem diferentes
    if ($telefoneAluno === $telefoneResponsavel) {
        echo "<script>
                alert('Os telefones do aluno e do responsável não podem ser iguais!');
                window.history.back();
              </script>";
        exit;
    }

    // Validação do formato dos emails
    if (!filter_var($emailAluno, FILTER_VALIDATE_EMAIL) || !filter_var($emailResponsavel, FILTER_VALIDATE_EMAIL)) {
        echo "<script>
                alert('Formato de email inválido!');
                window.history.back();
              </script>";
        exit;
    }

    // Validação do formato dos telefones (apenas números com 10 ou 11 dígitos)
    // (!preg_match('/^\d{10,11}$/', $telefoneAluno) || !preg_match('/^\d{10,11}$/', $telefoneResponsavel)) {
    //   echo "<script>
    //            alert('Formato de telefone inválido! O telefone deve conter apenas números e ter 10 ou 11 dígitos.');
    //window.history.back();
    //          </script>";
    //exit;
    //}

    // Prepara a query SQL para inserir os dados
    $sql = "INSERT INTO dados_alunos_para_cadastro
            (nomeAluno, emailAluno, telefoneAluno, nomeResponsavel, emailResponsavel, telefoneResponsavel, id_serie_turma) 
            VALUES (:nomeAluno, :emailAluno, :telefoneAluno, :nomeResponsavel, :emailResponsavel, :telefoneResponsavel, :serieTurmaTurno)";

    $stmt = $conn->prepare($sql);

    // Vincula os valores aos parâmetros
    $stmt->bindParam(':nomeAluno', $nomeAluno);
    $stmt->bindParam(':emailAluno', $emailAluno);
    $stmt->bindParam(':telefoneAluno', $telefoneAluno);
    $stmt->bindParam(':nomeResponsavel', $nomeResponsavel);
    $stmt->bindParam(':emailResponsavel', $emailResponsavel);
    $stmt->bindParam(':telefoneResponsavel', $telefoneResponsavel);
    $stmt->bindParam(':serieTurmaTurno', $serieTurmaTurno);

    // Executa a query
    $stmt->execute();

    // Redireciona para a página principal com uma mensagem de sucesso
    echo "<script>
            alert('Dados inseridos com sucesso!');
            window.location.href = 'https://www.colegioavila.com.br';
          </script>";
} catch (PDOException $e) {
    // Mostra uma mensagem de erro e mantém o usuário na página
    echo "<script>
     //     alert('Aluno já cadastrado: " . $e->getMessage() . "' );
            alert('Aluno já cadastrado.' );
            window.history.back();
          </script>";
}
?>
