<?php
// Configuração do banco de dados
$servername = "localhost";
$username = "kaltekgo_admin";
$password = "kaltek@2024";
$dbname = "kaltekgo_avila";

// Criar conexão
$conn = new mysqli($servername, $username, $password, $dbname);

// Verificar conexão
if ($conn->connect_error) {
    die("Conexão falhou: " . $conn->connect_error);
}

// Consulta SQL para obter os dados
$sql = "
SELECT 
    dados_alunos_para_cadastro.id,
    dados_alunos_para_cadastro.nomeAluno,
    dados_alunos_para_cadastro.nomeResponsavel,
    dados_alunos_para_cadastro.emailAluno,
    dados_alunos_para_cadastro.emailResponsavel,
    dados_alunos_para_cadastro.telefoneAluno,
    dados_alunos_para_cadastro.telefoneResponsavel,
    dados_alunos_para_cadastro.data_criacao_cadastro,
    serie_turma_turno.identificador_serie,
    serie_turma_turno.identificador_turma,
    serie_turma_turno.identificador_turno
FROM 
    dados_alunos_para_cadastro
INNER JOIN 
    serie_turma_turno 
ON 
    dados_alunos_para_cadastro.id_serie_turma = serie_turma_turno.id_serie_turma
WHERE 
    dados_alunos_para_cadastro.id_serie_turma != 43
ORDER BY 
    dados_alunos_para_cadastro.nomeAluno ASC;
";

$result = $conn->query($sql);
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Relatório de Alunos</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 20px;
        }
        h1 {
            text-align: center;
            color: #333;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
            background: #fff;
        }
        table th, table td {
            border: 1px solid #ddd;
            padding: 4px;
            text-align: left;
            font-size: 12px;
        }
        table th {
            background-color: #4CAF50;
            color: white;
        }
        table tr:nth-child(even) {
            background-color: #f2f2f2;
        }
        table tr:hover {
            background-color: #ddd;
        }
    </style>
    <script>
        // Função para aplicar a máscara de telefone
        function formatarTelefone(telefone) {
            const tel = telefone.replace(/\D/g, ''); // Remove caracteres não numéricos
            if (tel.length === 11) {
                return `(${tel.slice(0, 2)}) ${tel.slice(2, 7)}-${tel.slice(7)}`; // Formato (XX) XXXXX-XXXX
            } else if (tel.length === 10) {
                return `(${tel.slice(0, 2)}) ${tel.slice(2, 6)}-${tel.slice(6)}`; // Formato (XX) XXXX-XXXX
            }
            return telefone; // Retorna sem formatação se não atender ao formato esperado
        }

        // Aplica a máscara de telefone nos elementos da tabela
        window.onload = function () {
            const telefones = document.querySelectorAll('.telefone');
            telefones.forEach(function (telefone) {
                telefone.textContent = formatarTelefone(telefone.textContent);
            });
        };
    </script>
</head>
<body>
    <h1>Relatório de Alunos</h1>
    <table >
        <thead>
            <tr>
                <th>Nome do Aluno</th>
                <th>Nome do Responsável</th>
                <th>Email do Aluno</th>
                <th>Email do Responsável</th>
                <th>Telefone do Aluno</th>
                <th>Telefone do Responsável</th>
                <th>Série</th>
                <th>Turma</th>
                <th>Turno</th>
                <th>Data de Cadastro</th>
            </tr>
        </thead>
        <tbody>
            <?php
            if ($result->num_rows > 0) {
                // Loop para exibir os dados
                while ($row = $result->fetch_assoc()) {
                    // Formatar a data para dd/mm/yyyy
                    $dataCadastro = date('d/m/Y H:i:s', strtotime($row["data_criacao_cadastro"]));

                    echo "<tr>";
                    echo "<td style='text-transform: uppercase; font-size: 11px;'>" . $row["nomeAluno"] . "</td>";
                    echo "<td style='text-transform: uppercase; font-size: 11px;'>" . $row["nomeResponsavel"] . "</td>";
                    echo "<td>" . $row["emailAluno"] . "</td>";
                    echo "<td>" . $row["emailResponsavel"] . "</td>";
                    echo "<td class='telefone'>" . $row["telefoneAluno"] . "</td>";
                    echo "<td class='telefone'>" . $row["telefoneResponsavel"] . "</td>";
                    echo "<td>" . $row["identificador_serie"] . "</td>";
                    echo "<td>" . $row["identificador_turma"] . "</td>";
                    echo "<td>" . $row["identificador_turno"] . "</td>";
                    echo "<td>" . $dataCadastro . "</td>";
                    echo "</tr>";
                }
            } else {
                echo "<tr><td colspan='11'>Nenhum registro encontrado.</td></tr>";
            }
            ?>
        </tbody>
    </table>
</body>
</html>

<?php
// Fechar a conexão com o banco de dados
$conn->close();
?>
