<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="UTF-8">
  <title>Busca com AJAX</title>
  <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js"></script>

  <style>
  body {
      font-family: Arial, sans-serif;
      background-color: #ffffff;
      margin: 20px;
      color: #000000;
    }

    .container-fluid {
      width: 90%;
    }

    h4, h5 {
      margin: 0 0 10px;
    }

    .btn-cadastrar, .filtro-btns {
      margin-left: 15px;
      margin-bottom: 10px;
    }

    .table-responsive-custom {
      overflow-x: auto;
      -webkit-overflow-scrolling: touch;
      margin: 0 15px 20px 15px;
      display: block;
    }

    table {
      white-space: nowrap;
      width: 100%;
      border-collapse: collapse;
      background-color: #ffffff;
      box-shadow: 0 0 10px rgba(0,0,0,0.1);
      text-transform: uppercase;
      min-width: 700px;
    }

    th, td {
      padding: 12px 15px;
      text-align: left;
      font-size: 12px;
      border: 1px solid #000;
      vertical-align: middle !important;
    }

    th {
      background-color: #000;
      color: #fff;
    }

    tr:nth-child(even) {
      background-color: #f4f4f4;
    }

    tr:hover {
      background-color: #e0e0e0;
    }

    .mensagem-erro {
      color: red;
      font-size: 11px;
      margin-top: 4px;
      display: none;
    }

    .input-error {
      border: 2px solid red !important;
      background-color: #ffe6e6;
    }
    .input-vermelho {
    color: red;
}


    @media (max-width: 768px) {
      .btn-cadastrar, .filtro-btns .btn {
        width: 100% !important;
        margin: 10px auto;
        font-size: 16px;
        height: 45px;
        padding: 10px 12px;
      }

      .form-group label,
      .form-control {
        font-size: 14px;
      }

      .form-control,
      input[type="text"],
      select {
        height: 40px;
      }

      .table-responsive-custom {
        overflow-x: auto;
        display: block;
      }

      table {
        width: 1000px;
      }

      .table th, .table td {
        min-width: 125px;
        font-size: 14px;
        padding: 8px 10px;
      }

      h4 {
        text-align: center;
      }
    }
    .input-vermelho {
    color: red;
}
  #termo {
    width: 100%;
  }
  </style>
</head>
<body class="container-fluid">
  <h2>Buscar Alunos</h2>
 <div>
  <form id="formBusca" class="form-horizontal" style="margin-bottom:20px;">
  <div class="form-group">
    <div class="col-xs-12 col-sm-9">
      <input type="text" name="termo" id="termo" class="form-control" placeholder="Digite o nome do aluno">
    </div>
    <div class="col-xs-12 col-sm-3">
      <button type="submit" class="btn btn-primary btn-block">Buscar</button>
    </div>
  </div>
</form>


</div>
  <div id="resultado"></div>

  <script>
    $('#formBusca').on('submit', function(e) {
      e.preventDefault();

      const termo = $('#termo').val();

      $.ajax({
        url: 'consulta_aluno.php',
        method: 'POST',
        data: { termo: termo },
        success: function(resposta) {
          $('#resultado').html(resposta);
        },
        error: function() {
          $('#resultado').html('<div class="alert alert-danger">Erro na busca.</div>');
        }
      });
    });
  </script>
  <script>
  // Listener para clique nos <th> com a classe "coluna-info"
  $(document).on('click', '.coluna-info', function () {
    const coluna = $(this).data('coluna');

    // Requisição para info_tarefa.php (ou o arquivo que quiser)
    $.ajax({
      url: 'info_tarefa.php',
      method: 'POST',
      data: { coluna: coluna },
      success: function (resposta) {
        $('#modalContent').html(resposta);
        $('#modalInfo').modal('show');
      },
      error: function () {
        $('#modalContent').html('<div class="alert alert-danger">Erro ao carregar as informações.</div>');
        $('#modalInfo').modal('show');
      }
    });
  });
</script>

  <!-- Modal -->
<div class="modal fade" id="modalInfo" tabindex="-1" role="dialog" aria-labelledby="modalInfoLabel">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header bg-success text-white text-uppercase">
        <button type="button" class="close" data-dismiss="modal" aria-label="Fechar">
          <span aria-hidden="true">&times;</span>
        </button>
        <h4 class="modal-title" id="modalInfoLabel">Informações da Tarefa</h4>
      </div>
      <div class="modal-body" id="modalContent">
        Carregando...
      </div>
    </div>
  </div>
</div>
</body>
</html>
