<?php 
// Conexão com o banco
$host = "localhost";
$user = "kaltekgo_admin";
$pass = "kaltek@2024";
$db   = "kaltekgo_avila";

$conn = new mysqli($host, $user, $pass, $db);
if ($conn->connect_error) {
    die("Erro de conexão: " . $conn->connect_error);
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Lançamento de Notas</title>
    <meta name="viewport" content="width=device-width, initial-scale=1"> <!-- Responsivo -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<style>
/* === Remover setas dos inputs === */
/* Chrome, Safari, Edge, Opera */
input[type=number]::-webkit-outer-spin-button,
input[type=number]::-webkit-inner-spin-button {
  -webkit-appearance: none;
  margin: 0;
}
/* Firefox */
input[type=number] {
  -moz-appearance: textfield;
}

/* === Container === */
body.container-fluid {
  max-width: 80%;  /* no desktop fica 80% */
  margin: 0 auto;  /* centralizado */
  padding-bottom: 50px;
}

/* Input padrão (desktop) */
input[type=number] {
  width: 100%;
  max-width: 100px; /* no desktop até 150px */
}

/* Ajustes mobile */
@media (max-width: 768px) {
  body.container-fluid {
    max-width: 100%; /* ocupa toda a largura no mobile */
  }

  input[type=number] {
    width: 50px;  /* no mobile fixa em 200px */
    max-width: 200px;
  }

  h2 {
    font-size: 20px;
  }

  .btn {
    margin-top: 5px;
    width: 100%; /* botões ocupam largura inteira no mobile */
  }

  .table-responsive {
    border: none;
  }
}
</style>
</head>
<body class="container-fluid"> <!-- fluid para ocupar bem em celulares -->

    <h2 class="text-center">Lançamento de Notas Integrada/Simulado</h2>
    <div class="text-right">
        <a href="index.php" class="btn btn-primary">Voltar</a>
    </div>
    <br>

    <div id="mensagem"></div> <!-- Mensagem Ajax -->

    <!-- Select de turmas -->
    <div class="form-group">
        <label for="turma">Selecione a Turma:</label>
        <select id="turma" class="form-control text-uppercase">
            <option value="">-- Escolha a Turma --</option>
            <?php
            $sql = "SELECT * FROM serie_turma_turno WHERE id_serie_turma BETWEEN 27 AND 33 ORDER BY id_serie_turma ASC";
            $res = $conn->query($sql);
            while ($row = $res->fetch_assoc()) {
                echo "<option value='{$row['id_serie_turma']}'>
                        {$row['identificador_serie']} - 
                        {$row['identificador_turma']} - 
                        {$row['identificador_turno']}
                      </option>";
            }
            ?>
        </select>
    </div>

    <!-- Formulário para salvar -->
    <form id="formNotas">
        <input type="hidden" name="id_turma" id="id_turma">

        <!-- Tabela alunos -->
   <div class="table-responsive">
  <table class="table table-bordered table-striped table-condensed" id="tabela-alunos" style="display:none;">
      <thead>
          <tr>
              <th class="hidden-xs">Matrícula</th>   <!-- escondido no mobile -->
              <th>Nome</th>
              <th class="hidden-xs">Série</th>       <!-- escondido no mobile -->
              <th class="hidden-xs">Turma</th>       <!-- escondido no mobile -->
              <th style="width:70px">Nota</th>
          </tr>
      </thead>
      <tbody></tbody>
  </table>
</div>


        <div class="text-right">
            <button type="submit" class="btn btn-success">Salvar Notas</button>
            <a href="index.php" class="btn btn-primary">Voltar</a>
        </div>
    </form>

<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
<script>
$(document).ready(function(){
    // Carregar alunos ao escolher a turma
    $("#turma").change(function(){
        var turma_id = $(this).val();
        $("#id_turma").val(turma_id);
        if(turma_id != ""){
            $.ajax({
                url: "buscar_alunos.php",
                type: "POST",
                data: {id_turma: turma_id},
                success: function(data){
                    $("#tabela-alunos tbody").html(data);
                    $("#tabela-alunos").show();
                }
            });
        } else {
            $("#tabela-alunos").hide();
        }
    });

    // Envio do formulário via AJAX
    $("#formNotas").submit(function(e){
        e.preventDefault();
        $.ajax({
            url: "salvar_notas.php",
            type: "POST",
            data: $(this).serialize(),
            success: function(resp){
                $("#mensagem").html(
                    '<div class="alert alert-success alert-dismissible fade in">' +
                        '<a href="#" class="close" data-dismiss="alert">&times;</a>' +
                        '✅ ' + resp +
                    '</div>'
                );
            },
            error: function(){
                $("#mensagem").html(
                    '<div class="alert alert-danger alert-dismissible fade in">' +
                        '<a href="#" class="close" data-dismiss="alert">&times;</a>' +
                        '❌ Erro ao salvar notas!' +
                    '</div>'
                );
            }
        });
    });
});
</script>

</body>
</html>
