<?php 
$host = "localhost";
$user = "kaltekgo_admin";
$pass = "kaltek@2024";
$db   = "kaltekgo_avila";

$conn = new mysqli($host, $user, $pass, $db);
if ($conn->connect_error) {
    die("Erro: " . $conn->connect_error);
}

$notas = []; // precisa inicializar o array

// Valida e normaliza os valores
foreach ($_POST['nota'] as $matricula => $valor) {
    $n = str_replace(',', '.', $valor);

    if ($n === '' || !is_numeric($n)) {
        $n = null; // pode salvar NULL no banco se permitido
    } else {
        $n = floatval($n);
        if ($n < 0)  $n = 0.0;
        if ($n > 10) $n = 10.0;
    }

    $notas[$matricula] = $n; // aqui você armazena no array
}

if (!empty($notas)) {
    $sql = "UPDATE alunos_fundamental1 SET nota = ? WHERE matricula = ?";
    $stmt = $conn->prepare($sql);

    foreach ($notas as $matricula => $nota) {
        // se a coluna "nota" aceita NULL, precisa tratar assim:
        if ($nota === null) {
            $sqlNull = "UPDATE alunos_fundamental1 SET nota = NULL WHERE matricula = ?";
            $stmtNull = $conn->prepare($sqlNull);
            $stmtNull->bind_param("s", $matricula);
            $stmtNull->execute();
        } else {
            $stmt->bind_param("ds", $nota, $matricula);
            $stmt->execute();
        }
    }
    echo "Notas salvas com sucesso!";
} else {
    echo "Nenhuma nota recebida.";
}
?>
