<?php
session_start();

$pdo = new PDO("mysql:host=localhost;dbname=kaltekgo_avila", "kaltekgo_admin", "kaltek@2024");

$id_professor = $_SESSION['idProfessor'] ?? null;
$tipo = $_SESSION['tipoUsuario'];

// Função para buscar todas as turmas (sem filtro)
function buscarTodasTurmas($pdo) {
    return $pdo->query("SELECT * FROM serie_turma_turno WHERE id_serie_turma BETWEEN 15 AND 33;")->fetchAll(PDO::FETCH_ASSOC);
}

// Função para buscar todas as disciplinas (sem filtro)
function buscarTodasDisciplinas($pdo) {
    return $pdo->query("SELECT * FROM disciplinas_fundamental1 ORDER BY nomeDisciplina ASC")->fetchAll(PDO::FETCH_ASSOC);
}

// Função para buscar turmas vinculadas ao professor
function buscarTurmasDoProfessor($pdo, $id_professor) {
    $stmt = $pdo->prepare("
        SELECT DISTINCT stt.* 
        FROM serie_turma_turno stt
        INNER JOIN disciplinaProfessor_fundamental1 dp ON stt.id_serie_turma = dp.id_turma
        WHERE dp.id_professor = ?
    ");
    $stmt->execute([$id_professor]);
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
}

// Função para buscar disciplinas vinculadas ao professor
function buscarDisciplinasDoProfessor($pdo, $id_professor, $id_turma = null) {
    if ($id_turma) {
        $stmt = $pdo->prepare("
            SELECT d.id_disciplina, d.nomeDisciplina
            FROM disciplinas_fundamental1 d
            INNER JOIN disciplinaProfessor_fundamental1 dp ON d.id_disciplina = dp.id_disciplina
            WHERE dp.id_professor = ? AND dp.id_turma = ?
        ");
        $stmt->execute([$id_professor, $id_turma]);
    } else {
        $stmt = $pdo->prepare("
            SELECT d.id_disciplina, d.nomeDisciplina
            FROM disciplinas_fundamental1 d
            INNER JOIN disciplinaProfessor_fundamental1 dp ON d.id_disciplina = dp.id_disciplina
            WHERE dp.id_professor = ?
        ");
        $stmt->execute([$id_professor]);
    }
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
}

// Execução principal
if (isset($id_professor)) {
    if ($tipo == "coordenador") {
        // Mostrar todas as turmas e disciplinas (admin ou superusuário)
        $turmas = buscarTodasTurmas($pdo);
        $disciplinas = buscarTodasDisciplinas($pdo);
    } else {
        // Mostrar turmas e disciplinas vinculadas ao professor
        $id_turma = $_GET['id_turma'] ?? null;
        $turmas = buscarTurmasDoProfessor($pdo, $id_professor);
        $disciplinas = buscarDisciplinasDoProfessor($pdo, $id_professor, $id_turma);
    }

    echo json_encode([
        'turmas' => $turmas,
        'disciplinas' => $disciplinas
    ]);
} else {
    echo json_encode(['erro' => 'Professor não autenticado']);
}
?>