<?php
// Conexão com o banco
$host = "localhost";
$usuario_db = "kaltekgo_admin";
$senha_db = "kaltek@2024";
$banco = "kaltekgo_avila";

$conn = new mysqli($host, $usuario_db, $senha_db, $banco);
if ($conn->connect_error) {
    die("Erro de conexão: " . $conn->connect_error);
}

// Busca disciplinas
$disciplinas = [];
$sql = "SELECT * FROM disciplinas ORDER BY nomeDisciplina";
$result = $conn->query($sql);
if ($result && $result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $disciplinas[] = $row;
    }
}

// Busca turmas
$turmas = [];
$sql = "SELECT * FROM serie_turma_turno WHERE id_serie_turma BETWEEN 15 AND 43 ORDER BY id_serie_turma ASC ";
$result = $conn->query($sql);
if ($result && $result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $turmas[] = $row;
    }
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Controle de Lançamento de Notas</title>
    <!-- Bootstrap 3 -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>

    <style>
        body, html {
            height: 100%;
            margin: 0;
        }
        .vh-center {
            display: flex;
            justify-content: center; /* horizontal */
            align-items: center;     /* vertical */
            min-height: 100vh;
        }
        .form-box {
            width: 100%;
            max-width: 90%; /* limita largura */
            background: #fff;
            padding: 30px;
            /*border-radius: 10px;
            box-shadow: 0px 4px 12px rgba(0,0,0,0.1);*/
        }
    </style>
</head>
<body class="text-uppercase bg-light">

<div class="vh-center">
    <div class="container form-box">
        <h2 class="text-center">Controle de Lançamento de Notas</h2>

        <form method="POST" id="formNotas">
            <div class="row">
                <!-- Coluna 1 -->
                <div class="col-md-4">
                    <label for="select1">Selecione uma Nota:</label>
                    <select id="select1" name="nota" class="form-control text-uppercase" required>
                        <option value="">-- Escolha --</option>
                        <option value="P1">P1</option>
                        <option value="P2">P2</option>
                        <option value="P3">P3</option>
                        <option value="RT">RT</option>
                    </select>
                </div>

                <!-- Coluna 2 -->
                <div class="col-md-4">
                    <label for="select2">Selecione uma disciplina:</label>
                    <select id="select2" name="disciplina" class="form-control text-uppercase" required>
                        <option value="">-- Escolha --</option>
                        <?php foreach($disciplinas as $d): ?>
                            <option value="<?= $d['id_disciplina'] ?>"><?= $d['nomeDisciplina'] ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <!-- Coluna 3 -->
                <div class="col-md-4">
                    <label for="select3">Selecione uma Turma:</label>
                    <select id="select3" name="turma" class="form-control text-uppercase" required>
                        <option value="">-- Escolha --</option>
                        <?php foreach($turmas as $t): ?>
                            <option value="<?= $t['id_serie_turma'] ?>"><?= $t['identificador_serie'] ?> - <?= $t['identificador_turma'] ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <!-- Coluna 4 -->
                <div class="col-md-4">
                    <label for="select4">Selecione um trimestre:</label>
                    <select id="select4" name="trimestre" class="form-control text-uppercase" required>
                        <option value="">-- Escolha --</option>
                        <option value="1º TRIMESTRE">1º TRIMESTRE</option>
                        <option value="2º TRIMESTRE">2º TRIMESTRE</option>
                        <option value="3º TRIMESTRE">3º TRIMESTRE</option>
                    </select>
                </div>

                <!-- Coluna 5 -->
                <div class="col-md-4">
                    <label for="select5">Selecione um status:</label>
                    <select id="select5" name="status" class="form-control text-uppercase" required>
                        <option value="">-- Escolha --</option>
                        <option value="Lançada">Lançada</option>
                        <option value="Não lançada">Não Lançada</option>
                    </select>
                </div>
            </div>

            <hr>
 
            <!-- Exibir resultado -->
            <div id="resultado" class="alert alert-info" style="display:none;"></div>

            <!-- Botão -->
            <div class="text-center">
                <button type="submit" id="btnSalvar" class="btn btn-success btn-md" disabled>Salvar</button>
            </div>
        </form>
    </div>
</div>

<!-- Modal de Mensagens -->
<div class="modal fade" id="sucessoModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header bg-success text-white">
        <h5 class="modal-title">Mensagem</h5>
      </div>
      <div class="modal-body">
        <!-- mensagem dinâmica aqui -->
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-success" id="btnOkSucesso">Ok</button>
      </div>
    </div>
  </div>
</div>

<script>
$(document).ready(function(){
    $("select").on("change", function(){
        var s1 = $("#select1").val();
        var s2 = $("#select2 option:selected").text();
        var s3 = $("#select3 option:selected").text();
        var s4 = $("#select4").val();
        var s5 = $("#select5").val();
        
        var v2 = $("#select2").val();
        var v3 = $("#select3").val();

        if (s1 || s2 || s3 || s4 || s5) {
            $("#resultado").html(
                "Você escolheu: <br>" +
                "NOTA: " + (s1 || "-") + "<br>" +
                "DISCIPLINA: " + (v2 ? s2 : "-") + "<br>" +
                "TURMA: " + (v3 ? s3 : "-") + "<br>" +
                "TRIMESTRE: " + (s4 || "-") + "<br>" +
                "STATUS: " + (s5 || "-")
            ).fadeIn();
        } else {
            $("#resultado").fadeOut();
        }

        if (s1 && s2 && s3 && s4 && s5) {
            $("#btnSalvar").prop("disabled", false);
        } else {
            $("#btnSalvar").prop("disabled", true);
        }
    });

    $("#btnSalvar").prop("disabled", true);

    document.getElementById("formNotas").addEventListener("submit", function(e) {
        e.preventDefault();

        const form = this;
        const dados = new FormData(form);

        fetch("salvar.php", {
            method: "POST",
            body: dados
        })
        .then(res => res.json())
        .then(resposta => {
            document.querySelector("#sucessoModal .modal-body").innerHTML = resposta.mensagem;

            if (resposta.status === "sucesso") {
                $("#sucessoModal .modal-header").removeClass("bg-danger").addClass("bg-success");
            } else {
                $("#sucessoModal .modal-header").removeClass("bg-success").addClass("bg-danger");
            }

            $('#sucessoModal').modal('show');

            document.getElementById("btnOkSucesso").onclick = function() {
                if (resposta.status === "sucesso") {
                    window.location.href = "index.php";
                } else {
                    $('#sucessoModal').modal('hide');
                }
            };
        })
        .catch(() => {
            document.querySelector("#sucessoModal .modal-body").innerHTML = "Erro na comunicação com o servidor.";
            $("#sucessoModal .modal-header").removeClass("bg-success").addClass("bg-danger");
            $('#sucessoModal').modal('show');
        });
    });
});
</script>

</body>
</html>
