<?php
// Conexão com o banco
$host = "localhost";
$usuario_db = "kaltekgo_admin";
$senha_db = "kaltek@2024";
$banco = "kaltekgo_avila";

$conn = new mysqli($host, $usuario_db, $senha_db, $banco);
if ($conn->connect_error) {
    die("Erro de conexão: " . $conn->connect_error);
}

// Turma e Trimestre selecionados (via GET)
$idTurma = isset($_GET['turma']) ? (int)$_GET['turma'] : null;
$trimestreSelecionado = isset($_GET['trimestre']) ? $_GET['trimestre'] : "";

// Buscar turmas disponíveis
$turmas = [];
$sqlTurmas = "SELECT * FROM serie_turma_turno WHERE id_serie_turma BETWEEN 15 AND 43 ORDER BY id_serie_turma ASC";
$resultTurmas = $conn->query($sqlTurmas);
if ($resultTurmas && $resultTurmas->num_rows > 0) {
    while ($row = $resultTurmas->fetch_assoc()) {
        $turmas[] = $row;
    }
}

// Inicializa resultado
$resultDisciplinas = null;

// Se turma selecionada, buscar lançamentos
if ($idTurma) {
    $sqlDisciplinas = "
        SELECT 
            ln.*,                 
            d.nomeDisciplina
        FROM lancamentos_notas ln
        INNER JOIN disciplinas d
            ON ln.idDisciplina = d.id_disciplina
        WHERE ln.idTurma = ?
    ";

    // Se trimestre também foi selecionado, aplica o filtro
    if (!empty($trimestreSelecionado)) {
        $sqlDisciplinas .= " AND ln.trimestre = ?";
    }

    $sqlDisciplinas .= "
        ORDER BY 
            d.nomeDisciplina ASC,
            CASE ln.trimestre
                WHEN '1º TRIMESTRE' THEN 1
                WHEN '2º TRIMESTRE' THEN 2
                WHEN '3º TRIMESTRE' THEN 3
                ELSE 4
            END ASC
    ";

    $stmt = $conn->prepare($sqlDisciplinas);

    if (!empty($trimestreSelecionado)) {
        $stmt->bind_param("is", $idTurma, $trimestreSelecionado);
    } else {
        $stmt->bind_param("i", $idTurma);
    }

    $stmt->execute();
    $resultDisciplinas = $stmt->get_result();
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Controle Lançamento de Notas</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
    <style>
        .nao-lancada { background: #f8d7da; color: #721c24; }
        .lancada { background: #d4edda; color: #155724; }

        body { font-family: Arial, sans-serif; background-color: #ffffff; margin: 20px; color: #000000; text-transform: uppercase;}
        .container-fluid { width: 100%; }
        table { white-space: nowrap; width: 100%; border-collapse: collapse; background-color: #ffffff; text-transform: uppercase; min-width: 700px; text-align: center; }
        th, td { padding: 12px 15px; font-size: 12px; border: 1px solid #000; vertical-align: middle !important; text-align: center; }
        th { background-color: #000; color: #fff; }
        tr:nth-child(even) { background-color: #f4f4f4; }
        tr:hover { background-color: #e0e0e0; }
        td {border: 1px solid #000 !important}

        /* Ajuste dos selects */
        .form-group {
            display: inline-block;
            margin-right: 20px;
            text-align: center; /* Label alinhado à esquerda */
        }

        .form-group label {
            display: block;   /* Fica acima do select */
            margin-bottom: 5px;
            font-weight: normal;
        }

        .form-control {
            border-radius: 10 !important; /* Quadrado */
            text-align: center !important; /* Alinhado à esquerda */
            text-transform: uppercase;
        }
    </style>
</head>
<body class="container-fluid">
    <h3 class="text-center">Controle Lançamento de Notas</h3>

    <!-- Select de Turma e Trimestre -->
    <form method="GET" class="text-center form-inline" style="margin-bottom:20px;">
        <div class="form-group">
            <label for="selectTurma">Turma:</label>
            <select id="selectTurma" name="turma" onchange="this.form.submit()" class="form-control" style="width:150px;">
                <option value="">-- Selecione --</option>
                <?php foreach($turmas as $t): ?>
                    <option value="<?= $t['id_serie_turma'] ?>" <?= ($t['id_serie_turma']==$idTurma)?'selected':''; ?>>
                        <?= $t['identificador_serie'] ?> - <?= $t['identificador_turma'] ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <div class="form-group">
            <label for="selectTrimestre">Trimestre:</label>
            <select id="selectTrimestre" name="trimestre" onchange="this.form.submit()" class="form-control" style="width:150px;">
                <option value="">-- Todos --</option>
                <option value="1º TRIMESTRE" <?= ($trimestreSelecionado=="1º TRIMESTRE")?"selected":""; ?>>1º TRIMESTRE</option>
                <option value="2º TRIMESTRE" <?= ($trimestreSelecionado=="2º TRIMESTRE")?"selected":""; ?>>2º TRIMESTRE</option>
                <option value="3º TRIMESTRE" <?= ($trimestreSelecionado=="3º TRIMESTRE")?"selected":""; ?>>3º TRIMESTRE</option>
            </select>
        </div>
    </form>

    <?php if ($idTurma): ?>
        <?php if ($resultDisciplinas && $resultDisciplinas->num_rows > 0): ?>
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>Disciplina</th>
                        <th>Nota</th>
                        <th>Trimestre</th>
                        <th>Status</th>
                        <th>Data Atualização</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while ($disc = $resultDisciplinas->fetch_assoc()): 
                        $status = $disc['status'] ?? 'Não lançada';
                        $classe = ($status === 'Lançada') ? 'lancada' : 'nao-lancada';
                    ?>
                        <tr>
                            <td><?php echo $disc['nomeDisciplina']; ?></td>
                            <td><?php echo $disc['nota']; ?></td>
                            <td><?php echo $disc['trimestre']; ?></td>
                            <td class="<?php echo $classe; ?>"><?php echo $status; ?></td>
                            <td><?php echo date('d/m/Y H:i:s', strtotime($disc['data_atualizacao'])); ?></td>
                        </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        <?php else: ?>
            <p class="text-center alert alert-info">Nenhum resultado encontrado para esta turma.</p>
        <?php endif; ?>
    <?php endif; ?>
</body>
</html>
