<?php
session_start(); // Iniciar a sessão para armazenar dados do usuário
include('conexao.php'); // Certifique-se de que o arquivo 'conexao.php' está configurado corretamente

// Verificar se o formulário foi enviado
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $username = $_POST['username'];
    $password = $_POST['password'];

    // Consulta segura usando prepared statements para evitar SQL injection
    $stmt = $conn->prepare("SELECT * FROM login_responsaveis_ege WHERE login = ? AND senha = ? LIMIT 1");
    $stmt->bind_param("ss", $username, $password);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $resultado = $result->fetch_assoc();
        $valid_username = $resultado['login'];
        $valid_password = $resultado['senha'];
        $pagina = $resultado['nivel'];
        $nome_sessao = $resultado['nome'];

        // Verificar as credenciais
        if ($username == $valid_username && $password == $valid_password) {
            // Se as credenciais estiverem corretas, armazenar o nome de usuário na sessão
            $_SESSION['login'] = $username;
            $_SESSION['nivel'] = $pagina;
            $_SESSION['nome'] = $nome_sessao;

            // Redirecionar para a página protegida
            header("Location: /".$_SESSION['nivel']."");
            exit();
        } else {
            // Se as credenciais estiverem incorretas, exibir uma mensagem de erro
            $error = "usuário ou senha incorretos!";
            
        }
    } else {
        // Se nenhum usuário foi encontrado, exibir uma mensagem de erro
        $error = "Nome de usuário ou senha incorretos!";
    }

    $stmt->close(); // Fechar o statement
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title>Escola Geração Eleita</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css">
    <link rel="stylesheet" href="style.css">
</head>
<body>

<div class="container">
    <div class="row justify-content-center mt-5">
        <div class="col-md-6 col-lg-4">
            <div class="card shadow-lg">
                <div class="card-body p-5 text-center">
		 <h4></h4>
			<p></p>
                    <img src="logo.png" alt="auspet" class="mb-4" width="250px">
                    <form id="loginForm" action="#" METHOD="POST">
                        <div class="form-group">
                            <input type="text" class="form-control" id="email" name="username" placeholder="Digite aqui o seu usuário" required>
                        </div>
                        <div class="form-group">
                            <input type="password" class="form-control" id="password" name="password" placeholder="Digite aqui o sua senha" required>
                            <p style="padding:5px 0px 0px 0px;">
                             <input id="showPassword" class="btn btn-primary btn-block" type="button" value="MOSTRAR SENHA">
                            </p>
                        </div>
                        
                        
                        <input class="btn btn-primary btn-block" type="submit" value="ENTRAR">
                        <p class="mt-3 mb-0"><a href="#">Esqueceu a senha? Entrar em contato com a secretaria da escola.</a></p>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.3.1.slim.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.7/umd/popper.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js"></script>
</body>
</html>
<script>
$(document).ready(function(){
  $('#showPassword').on('click', function(){
    
    var passwordField = $('#password');
    var passwordFieldType = passwordField.attr('type');
    if(passwordFieldType == 'password')
    {
        passwordField.attr('type', 'text');
        $(this).val('OCULTAR SENHA');
    } else {
        passwordField.attr('type', 'password');
        $(this).val('MOSTRAR SENHA');
    }
  });
});
</script>