<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Sala Marker</title>
    <!-- Bootstrap 3 -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
    <style>
        html, body {
            height: 100%;
            margin: 0;
        }
        body {
            display: flex;
            justify-content: center;  /* Centraliza horizontal */
            align-items: center;      /* Centraliza vertical */
        }
        .form-row {
            width: 100%;
        }
        
        h2 {
          justify-content: center;  /* Centraliza horizontal */
          margin-bottom: 20px; 
        }
    
        
    </style>
</head>
<body>

<div class="container">
    
    <form id="formVH" action="salvar.php" method="POST">
        <div class="row form-row text-center">
            <h2>Reserva da Sala Maker<br>Data Específica</h2>
            
            <!-- Select -->
<div class="col-md-4 col-xs-12">
    <div class="form-group text-left">
        <label>Horário</label>
        <select class="form-control" name="horario" required>
            <option value="">Selecione o horário</option>
            <option>07:05</option>
           <option>07:55</option>
                    <option>08:45</option>
                    <option>10:00</option>
                    <option>10:50</option>
                    <option>11:40</option>
                    <option>13:20</option>
                    <option>14:10</option>
                    <option>15:30</option>
                    <option>16:10</option>
                    <option>16:50</option>
                    <option>17:40</option>
        </select>
    </div>
</div>

<div class="col-md-4 col-xs-12">
    <div class="form-group text-left">
        <label>Descrição</label>
        <input type="text" class="form-control text-uppercase" name="descricao" placeholder="Descrição da Reserva" maxlength="20" required>
    </div>
</div>

<div class="col-md-4 col-xs-12">
    <div class="form-group text-left">
        <label>Data</label>
        <input type="date" class="form-control" name="data_aula" required>
    </div>
</div>
 <br>
        <div class="text-center">
            <button type="submit" class="btn btn-primary">Reservar</button>
            <a href="index.php" class="btn btn-primary">Voltar para Início</a>
        </div>
    </form>
</div>

<!-- Modal Bootstrap -->
<div id="retornoModal" class="modal fade" role="dialog">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        <h4 class="modal-title">Mensagem</h4>
      </div>
      <div class="modal-body">
        <p id="mensagem"></p>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Fechar</button>
      </div>
    </div>
  </div>
</div>

<script>
$(function(){
    $("#formVH").on("submit", function(e){
        e.preventDefault(); // não envia normal

        $.post("salvar.php", $(this).serialize(), function(resposta){
            $("#mensagem").html(resposta);   // insere o retorno do PHP no modal
            $("#retornoModal").modal("show"); // abre o modal
        });
    });

    // Quando fechar o modal, recarrega a página
    $('#retornoModal').on('hidden.bs.modal', function () {
        location.reload();
    });
});
</script>

</body>
</html>
