<?php
// Conexão BD
$host = "localhost";
$db   = "kaltekgo_avila";
$user = "kaltekgo_admin";
$pass = "kaltek@2024";

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("<div class='alert alert-danger'>Erro de conexão: " . $e->getMessage() . "</div>");
}

// Dados enviados
$horario   = $_POST['horario']   ?? '';
$descricao = $_POST['descricao'] ?? '';
$data_aula = $_POST['data_aula'] ?? '';

if (empty($horario) || empty($descricao) || empty($data_aula)) {
    echo "<div class='alert alert-warning'>⚠️ Preencha todos os campos.</div>";
    exit;
}

// Verifica se já existe reserva nesse horário e data
$stmt = $pdo->prepare("SELECT * FROM reserva_maker WHERE horario = :horario AND data_aula = :data_aula");
$stmt->execute([
    ':horario'   => $horario,
    ':data_aula' => $data_aula
]);
$reservaExistente = $stmt->fetch(PDO::FETCH_ASSOC);

if ($reservaExistente) {
    echo "<div class='alert alert-danger'>⚠️ Já existe uma reserva nesse horário e data!</div>";
    echo "<table class='table table-bordered table-striped'>
            <tr><th>Horário</th><td>{$reservaExistente['horario']}</td></tr>
            <tr><th>Data</th><td>{$reservaExistente['data_aula']}</td></tr>
            <tr><th>Descrição</th><td>{$reservaExistente['descricao']}</td></tr>
          </table>";
    exit;
}

// Insere no banco
$stmt = $pdo->prepare("INSERT INTO reserva_maker (horario, descricao, data_aula) 
                       VALUES (:horario, :descricao, :data_aula)");
$stmt->execute([
    ':horario'   => $horario,
    ':descricao' => $descricao,
    ':data_aula' => $data_aula
]);

echo "<div class='alert alert-success'>✅ Reserva salva com sucesso!</div>";
echo "<table class='table table-bordered table-striped'>
        <tr><th>Horário</th><td>{$horario}</td></tr>
        <tr><th>Data</th><td>{$data_aula}</td></tr>
        <tr><th>Descrição</th><td>{$descricao}</td></tr>
      </table>";
exit;
