<?php
// ==== Conexão com o banco (PDO) ====
$host = "localhost";
$user = "kaltekgo_admin";       
$pass = "kaltek@2024";          
$db   = "kaltekgo_avila";

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Erro na conexão: " . $e->getMessage());
}

// ==== Montar lista de turmas ====
$sql_turmas = "SELECT DISTINCT identificadorturma FROM alunos_confirmados_2025 ORDER BY identificadorturma";
$stmt_turmas = $pdo->query($sql_turmas);
$turmas = $stmt_turmas->fetchAll(PDO::FETCH_COLUMN);

// ==== Verifica turma selecionada ====
$turmaSelecionada = $_GET['turma'] ?? '';

// ==== Busca dos alunos ====
if ($turmaSelecionada) {
    $sql = "SELECT nome, identificadorturma 
            FROM alunos_confirmados_2025 
            WHERE identificadorturma = :turma 
            ORDER BY nome";
    $stmt = $pdo->prepare($sql);
    $stmt->execute(['turma' => $turmaSelecionada]);
} else {
    $sql = "SELECT nome, identificadorturma 
            FROM alunos_confirmados_2025 
            ORDER BY nome";
    $stmt = $pdo->query($sql);
}

$alunos = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="UTF-8">
<title>Etiquetas de Alunos</title>
<style>
    @page {
        size: A4;
        margin: 1cm;
    }

    body {
        font-family: Arial, sans-serif;
        margin: 0;
        padding: 1cm;
    }

    form {
        margin-bottom: 20px;
        text-align: center;
    }

    select, button {
        font-size: 14px;
        padding: 5px 10px;
        border-radius: 4px;
        border: 1px solid #666;
        background-color: #f8f8f8;
        cursor: pointer;
    }

    button:hover {
        background-color: #e0e0e0;
    }

    .container-etiquetas {
        display: flex;
        flex-wrap: wrap;
        justify-content: flex-start;
    }

    .etiqueta {
        width: 37mm;
        height: 25mm;
        border: 1px solid #000;
        box-sizing: border-box;
        margin: 2mm;
        padding: 4px;
        display: flex;
        flex-direction: column;
        justify-content: space-between;
        align-items: center;
        text-align: center;
        page-break-inside: avoid;
    }

    .nome {
        font-size: 13px;
        line-height: 1.2;
        word-wrap: break-word;
        overflow-wrap: break-word;
        max-height: 80%;
    }

    .turma {
        font-size: 12px;
        color: #333;
        margin-top: auto;
    }

    .botoes {
        text-align: center;
        margin-bottom: 15px;
    }

    @media print {
        form, .botoes, h3 { display: none; }
        body { margin: 0; padding: 0; }
    }
</style>
</head>
<body>

<h3 style="text-align:center;">Etiquetas de Alunos</h3>

<form method="get" action="">
    <label for="turma">Selecione a turma:</label>
    <select name="turma" id="turma" required>
        <option value="">-- Todas as turmas --</option>
        <?php foreach ($turmas as $t): ?>
            <option value="<?= htmlspecialchars($t) ?>" <?= ($turmaSelecionada == $t) ? 'selected' : '' ?>>
                <?= htmlspecialchars($t) ?>
            </option>
        <?php endforeach; ?>
    </select>
    <button type="submit">Gerar</button>
</form>

<?php if (!empty($alunos)): ?>
<div class="botoes">
    <button type="button" onclick="window.print()">🖨️ Imprimir</button>
</div>
<?php endif; ?>

<div class="container-etiquetas">
<?php
if (count($alunos) > 0) {
    foreach ($alunos as $aluno) {
        echo '<div class="etiqueta">';
        echo '<div class="nome">' . htmlspecialchars($aluno['nome']) . '</div>';
        echo '<div class="turma">' . htmlspecialchars($aluno['identificadorturma']) . '</div>';
        echo '</div>';
    }
} else {
    echo '<p style="text-align:center; width:100%;">Nenhum aluno encontrado.</p>';
}
?>
</div>

</body>
</html>
