<?php
setlocale(LC_TIME, 'pt_BR.utf8', 'pt_BR', 'Portuguese_Brazil');

// === Conexão com o banco (PDO) ===
$host = "localhost";
$user = "kaltekgo_admin";       
$pass = "kaltek@2024";          
$db   = "kaltekgo_avila";       

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Erro de conexão: " . $e->getMessage());
}

// === Buscar última atualização ===
$sqlData = "SELECT data_atualizacao 
              FROM calouros_veteranos 
          ORDER BY data_atualizacao DESC 
             LIMIT 1";
$stmt = $pdo->query($sqlData);
$ultimaAtualizacao = $stmt->fetchColumn();
$dataFormatada = $ultimaAtualizacao 
    ? date("d/m/Y H:i", strtotime($ultimaAtualizacao)) 
    : "Sem registros";
    
// === Buscar todos os alunos matriculados ===
$sqlAlunos = "SELECT 
                 * 
              FROM alunos_confirmados_2026 
              ORDER BY dataconfirmacao DESC";
$stmt = $pdo->query($sqlAlunos);
$dadosAlunos = $stmt->fetchAll(PDO::FETCH_ASSOC);


/* ================== CONSULTAS ================== */
// (Mantendo todas as consultas que você já tinha)
$sqledim = "SELECT 
    v.sala_matriz, 
    v.turma_nome AS turma, 
    v.vagas_fisicas, 
    v.ano_2025 AS ano_anterior, 
    v.id, 
    v.tooltip,
    COUNT(c.turma) AS matriculados,
    SUM(CASE WHEN c.veterano = 1 THEN 1 ELSE 0 END) AS veteranos,
    SUM(CASE WHEN c.calouro = 1 THEN 1 ELSE 0 END) AS novatos,
    (v.vagas_fisicas - COUNT(c.turma)) AS vagas_restantes,
    (v.ano_2025 - SUM(CASE WHEN c.veterano = 1 THEN 1 ELSE 0 END)) AS vagas_reais
FROM vagas_series_turmas v
LEFT JOIN calouros_veteranos c 
       ON v.turma_nome = c.turma
WHERE v.id BETWEEN 1 AND 13 
  AND v.turno = 'matutino'
GROUP BY v.sala_matriz, v.turma_nome, v.vagas_fisicas, v.ano_2025, v.id, v.tooltip
ORDER BY v.id ASC;
";
$stmt = $pdo->query($sqledim);
$dadosedim = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Educação Infantil - Vespertino
$sqlediv = "SELECT v.sala_matriz, v.turma_nome AS turma, v.vagas_fisicas, v.ano_2025 AS ano_anterior, v.id, v.tooltip,
    COUNT(c.turma) AS matriculados,
    SUM(CASE WHEN c.veterano = 1 THEN 1 ELSE 0 END) AS veteranos,
    SUM(CASE WHEN c.calouro = 1 THEN 1 ELSE 0 END) AS novatos,
    (v.vagas_fisicas - COUNT(c.turma)) AS vagas_restantes,
    (v.ano_2025 - SUM(CASE WHEN c.veterano = 1 THEN 1 ELSE 0 END)) AS vagas_reais
FROM vagas_series_turmas v
LEFT JOIN calouros_veteranos c ON v.turma_nome = c.turma
WHERE v.id BETWEEN 1 AND 13 
  AND turno = 'vespertino'
GROUP BY v.sala_matriz, v.turma_nome, v.vagas_fisicas, v.ano_2025, v.id, v.tooltip
ORDER BY v.id ASC";
$stmt = $pdo->query($sqlediv);
$dadosediv = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Fundamental I - Matutino
$sqlf1m = "SELECT v.sala_matriz, v.turma_nome AS turma, v.vagas_fisicas, v.ano_2025 AS ano_anterior, v.id, v.tooltip,
    COUNT(c.turma) AS matriculados,
    SUM(CASE WHEN c.veterano = 1 THEN 1 ELSE 0 END) AS veteranos,
    SUM(CASE WHEN c.calouro = 1 THEN 1 ELSE 0 END) AS novatos,
    (v.vagas_fisicas - COUNT(c.turma)) AS vagas_restantes,
    (v.ano_2025 - SUM(CASE WHEN c.veterano = 1 THEN 1 ELSE 0 END)) AS vagas_reais
FROM vagas_series_turmas v
LEFT JOIN calouros_veteranos c ON v.turma_nome = c.turma
WHERE v.id  BETWEEN 15 AND 32 AND v.turno = 'matutino'
GROUP BY v.sala_matriz, v.turma_nome, v.vagas_fisicas, v.ano_2025, v.id, v.tooltip
ORDER BY v.id ASC";
$stmt = $pdo->query($sqlf1m);
$dadosf1m = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Fundamental I - Vespertino
$sqlf1v = str_replace("matutino", "vespertino", $sqlf1m);
$stmt = $pdo->query($sqlf1v);
$dadosf1v = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Fundamental II - Matutino
$sqlf2m = "SELECT v.sala_matriz, v.turma_nome AS turma, v.vagas_fisicas, v.ano_2025 AS ano_anterior, v.id, v.tooltip,
    COUNT(c.turma) AS matriculados,
    SUM(CASE WHEN c.veterano = 1 THEN 1 ELSE 0 END) AS veteranos,
    SUM(CASE WHEN c.calouro = 1 THEN 1 ELSE 0 END) AS novatos,
    (v.vagas_fisicas - COUNT(c.turma)) AS vagas_restantes,
    (v.ano_2025 - SUM(CASE WHEN c.veterano = 1 THEN 1 ELSE 0 END)) AS vagas_reais
FROM vagas_series_turmas v
LEFT JOIN calouros_veteranos c ON v.turma_nome = c.turma
WHERE (v.turma_nome LIKE '%6º%' OR v.turma_nome LIKE '%7º%' OR v.turma_nome LIKE '%8º%' OR v.turma_nome LIKE '%9º%')
  AND turno = 'matutino'
GROUP BY v.sala_matriz, v.turma_nome, v.vagas_fisicas, v.ano_2025, v.id, v.tooltip
ORDER BY v.id ASC";
$stmt = $pdo->query($sqlf2m);
$dadosf2m = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Ensino Médio - Matutino
$sqlem = "SELECT v.sala_matriz, v.turma_nome AS turma, v.vagas_fisicas, v.ano_2025 AS ano_anterior, v.id, v.tooltip,
    COUNT(c.turma) AS matriculados,
    SUM(CASE WHEN c.veterano = 1 THEN 1 ELSE 0 END) AS veteranos,
    SUM(CASE WHEN c.calouro = 1 THEN 1 ELSE 0 END) AS novatos,
    (v.vagas_fisicas - COUNT(c.turma)) AS vagas_restantes,
    (v.ano_2025 - SUM(CASE WHEN c.veterano = 1 THEN 1 ELSE 0 END)) AS vagas_reais
FROM vagas_series_turmas v
LEFT JOIN calouros_veteranos c ON v.turma_nome = c.turma
WHERE (v.turma_nome LIKE '%1º ANO - M (2026)%' OR v.turma_nome LIKE '%2º ANO - M (2026)%')
  AND turno = 'matutino'
GROUP BY v.sala_matriz, v.turma_nome, v.vagas_fisicas, v.ano_2025, v.id, v.tooltip
ORDER BY v.id ASC";
$stmt = $pdo->query($sqlem);
$dadosem = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Todas as salas
$sqlall = "SELECT v.sala_matriz, v.turma_nome AS turma, v.vagas_fisicas, v.ano_2025 AS ano_anterior, v.id, v.tooltip,
    COUNT(c.turma) AS matriculados,
    SUM(CASE WHEN c.veterano = 1 THEN 1 ELSE 0 END) AS veteranos,
    SUM(CASE WHEN c.calouro = 1 THEN 1 ELSE 0 END) AS novatos,
    (v.vagas_fisicas - COUNT(c.turma)) AS vagas_restantes,
    (v.ano_2025 - SUM(CASE WHEN c.veterano = 1 THEN 1 ELSE 0 END)) AS vagas_reais
FROM vagas_series_turmas v
LEFT JOIN calouros_veteranos c ON v.turma_nome = c.turma
GROUP BY v.sala_matriz, v.turma_nome, v.vagas_fisicas, v.ano_2025, v.id, v.tooltip
ORDER BY v.id ASC";
$stmt = $pdo->query($sqlall);
$dadosall = $stmt->fetchAll(PDO::FETCH_ASSOC);


/* ================== FUNÇÃO DA TABELA ================== */
function renderTabela($dados) {
    // Inicializa acumuladores
    $total_vagas_fisicas = 0;
    //$total_ano_anterior  = 0;
    $total_veteranos     = 0;
    $total_novatos       = 0;
    $total_matriculados  = 0;
    $total_vagas_rest    = 0;
    $total_vagas_reais   = 0;
    $total_vagas_esp     = 0;
    

    ?>
    <div class="table-responsive">
      <table class="table table-bordered table-striped">
        <thead>
          <tr>
            <th>Sala Matriz</th>
            <th>Série / Turma</th>
            <th>Vagas Físicas</th>
            <th>Ano Anterior - 2025</th>
            <th>Rematricula</th>
            <th>Novatos</th>
            <th>Matriculados</th>
            <th>Vagas Atuais</th>
            <th>Não rematricularam</th>
            <th>Vagas Esperadas</th>
          </tr>
        </thead>
        <tbody>
          <?php if ($dados): ?>
            <?php foreach ($dados as $row): ?>
              <?php
                $vagas_esp = $row['vagas_restantes'] - $row['vagas_reais'];
                // Somatórios
                $total_vagas_fisicas += $row['vagas_fisicas'];
                //$total_ano_anterior  += $row['ano_anterior'];
                $total_veteranos     += $row['veteranos'];
                $total_novatos       += $row['novatos'];
                $total_matriculados  += $row['matriculados'];
                $total_vagas_rest    += $row['vagas_restantes'];
                $total_vagas_reais   += $row['vagas_reais'];
                $total_vagas_esp     += $vagas_esp;
                $vagas = $row['vagas_restantes'];

                // Define a cor conforme o valor
                  if ($vagas == 0) {
                        $cor = 'background-color: #ff4d4d;'; // vermelho
                        } elseif ($vagas >= 1 && $vagas <= 5) {
                             $cor = 'background-color: #fff176;'; // amarelo
                                 } elseif ($vagas >= 5 && $vagas <= 10) {
                             $cor = 'background-color: #80EF80;'; // amarelo
                                } else {
                                   $cor = ''; // sem cor
                                        }
              ?>
              <tr>
                <td><?= htmlspecialchars($row['sala_matriz']) ?></td>
                <td><?= htmlspecialchars($row['turma']) ?></td>
                <td><?= htmlspecialchars($row['vagas_fisicas']) ?></td>
                <td>
  <?= htmlspecialchars($row['ano_anterior']) ?>
  <?php if (in_array($row['id'], [25,33,34,41])): ?>
    <span data-toggle="tooltip" title="<?= htmlspecialchars($row['tooltip']) ?>" style="color: red; font-size: 15px;"> *</span>
  <?php endif; ?>
</td>

                <td><?= htmlspecialchars($row['veteranos']) ?></td>
                <td><?= htmlspecialchars($row['novatos']) ?></td>
                <td><?= htmlspecialchars($row['matriculados']) ?></td>
                <td style="<?= $cor ?>"><?= $vagas ?></td>
                <td><?= htmlspecialchars($row['vagas_reais']) ?></td>
                <td><?= htmlspecialchars($vagas_esp) ?></td>
              </tr>
            <?php endforeach; ?>
          <?php else: ?>
            <tr><td colspan="10" class="text-center">Nenhum registro encontrado.</td></tr>
          <?php endif; ?>
        </tbody>
        <?php if ($dados): ?>
        <tfoot>
          <tr style="font-weight: bold; background: #d9edf7;">
            <td colspan="2" class="text-right">TOTAL:</td>
            <td><?= $total_vagas_fisicas ?></td>
            <td><?= $total_ano_anterior ?></td>
            <td><?= $total_veteranos ?></td>
            <td><?= $total_novatos ?></td>
            <td><?= $total_matriculados ?></td>
            <td><?= $total_vagas_rest ?></td>
            <td><?= $total_vagas_reais ?></td>
            <td><?= $total_vagas_esp ?></td>
          </tr>
        </tfoot>
        <?php endif; ?>
      </table>
    </div>
    <?php
}

/* ================== FUNÇÃO TABELA DE ALUNOS ================== */
function renderTabelaAlunos($dadosAlunos) {
    ?>
    <div class="table-responsive" style="max-height: 500px; overflow-y: auto;">
  <table class="table table-bordered table-striped">

        <thead>
          <tr>
            <th>Matrícula</th>
            <th>Nome do Aluno</th>
            <th>Turma</th>
            <th>Data da Matrícula</th>
          </tr>
        </thead>
        <tbody>
          <?php if ($dadosAlunos): ?>
            <?php foreach ($dadosAlunos as $row): ?>
              <tr>
                <td><?= htmlspecialchars($row['matricula']) ?></td>
                <td><?= htmlspecialchars($row['nome']) ?></td>
                <td><?= htmlspecialchars($row['identificadorturma']) ?></td>
                <td><?= date("d/m/Y", strtotime($row['dataconfirmacao'])) ?></td>
              </tr>
            <?php endforeach; ?>
          <?php else: ?>
            <tr><td colspan="4" class="text-center">Nenhum aluno encontrado.</td></tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
    <?php
}

/* ================== INTERFACE ================== */
$data_atual = new DateTime();
$proximo_ano = $data_atual->modify('+1 year')->format('Y');

function somaNovatos($dados) { 
    $total = 0; foreach ($dados as $row) $total += $row['novatos']; 
    return $total; 
}
function somaVeteranos($dados) { 
    $total = 0; foreach ($dados as $row) $total += $row['veteranos']; 
    return $total; 
}

/* ================== FUNÇÃO RELATÓRIO ================== */
function renderTabelaRelatorio(PDO $pdo) {
    try {
        // === Datas e períodos ===
        $hoje = new DateTime();
        $hoje_formatado = $hoje->format('Y-m-d');

        // Intervalos dos anos letivos
        $inicio_2026 = '2025-06-26';
        $fim_2026 = $hoje_formatado;
        $inicio_2025 = '2024-06-26';
        $fim_2025 = (clone $hoje)->modify('-1 year')->format('Y-m-d');

        // === Totais gerais ===
        $sql2026 = "SELECT COUNT(*) FROM alunos_confirmados_2026 WHERE dataconfirmacao BETWEEN :inicio AND :fim";
        $stmt = $pdo->prepare($sql2026);
        $stmt->execute([':inicio' => $inicio_2026, ':fim' => $fim_2026]);
        $total_2026 = (int)$stmt->fetchColumn();

        $sql2025 = "SELECT COUNT(*) FROM alunos_confirmados_2025 WHERE dataconfirmacao BETWEEN :inicio AND :fim";
        $stmt = $pdo->prepare($sql2025);
        $stmt->execute([':inicio' => $inicio_2025, ':fim' => $fim_2025]);
        $total_2025 = (int)$stmt->fetchColumn();

        $variacao = $total_2025 > 0 ? (($total_2026 - $total_2025) / $total_2025) * 100 : 0;
        $icone = $variacao >= 0 ? '▲' : '▼';
        $cor   = $variacao >= 0 ? 'green' : 'red';

        // === Renderizar tabela anual ===
        ?>
        <div class="table-responsive mt-3">
          <table class="table table-bordered table-striped text-center">
            <thead style="background:#222; color:#fff; text-transform:uppercase;">
              <tr>
                <th>Período/Ano</th>
                <th>Data Inicial</th>
                <th>Data Final</th>
                <th>Total de Alunos Matriculados</th>
              </tr>
            </thead>
            <tbody>
              <tr>
                <td><strong>2025</strong></td>
                <td><?= date("d/m/Y", strtotime($inicio_2025)) ?></td>
                <td><?= date("d/m/Y", strtotime($fim_2025)) ?></td>
                <td><?= $total_2025 ?></td>
              </tr>
              <tr>
                <td><strong>2026</strong></td>
                <td><?= date("d/m/Y", strtotime($inicio_2026)) ?></td>
                <td><?= date("d/m/Y", strtotime($fim_2026)) ?></td>
                <td><?= $total_2026 ?></td>
              </tr>
            </tbody>
            <tfoot style="background:#f5f5f5; font-weight:bold;">
              <tr>
                <td colspan="3" class="text-right" style="padding: 11px 5px 10px 5px;">Variação entre períodos</td>
                <td>
                  <?= number_format($variacao, 2, ',', '.') ?>%
                  <span style="color:<?= $cor ?>; font-size:1.2em;"><?= $icone ?></span>
                </td>
              </tr>
            </tfoot>
          </table>
        </div>
        <?php

        /* ================== COMPARATIVO MENSAL ================== */

        $meses = [
            '06' => 'Junho',
            '07' => 'Julho',
            '08' => 'Agosto',
            '09' => 'Setembro',
            '10' => 'Outubro',
            //'11' => 'Novembro',
            //'12' => 'Dezembro',
            //'01' => 'Janeiro'
        ];

        $soma_2025 = 0;
        $soma_2026 = 0;
        $dados_2025 = [];
        $dados_2026 = [];
        $labels = [];
        echo'<h5 class="text-center mb-3" style="text-transform:uppercase; font-weight:bold;">
            Comparativo Mensal de Matrículas (2025 x 2026)
          </h5>';
        echo '<div class="table-responsive mt-4">';
        echo '<table class="table table-bordered table-striped text-center">';
        echo '<thead style="background:#004085; color:#fff; text-transform:uppercase;">';
        echo '<tr><th>Mês</th><th>2025</th><th>2026</th><th>Variação (%)</th></tr>';
        echo '</thead><tbody>';

        foreach ($meses as $numMes => $nomeMes) {
            $ano_2025 = 2024;
            $ano_2026 = 2025;

            $inicio_mes_2025 = "$ano_2025-$numMes-01";
            $fim_mes_2025 = date("Y-m-t", strtotime($inicio_mes_2025));
            $inicio_mes_2026 = "$ano_2026-$numMes-01";
            $fim_mes_2026 = date("Y-m-t", strtotime($inicio_mes_2026));

            $stmt = $pdo->prepare("SELECT COUNT(*) FROM alunos_confirmados_2025 WHERE dataconfirmacao BETWEEN :i AND :f");
            $stmt->execute([':i' => $inicio_mes_2025, ':f' => $fim_mes_2025]);
            $total_mes_2025 = (int)$stmt->fetchColumn();

            $stmt = $pdo->prepare("SELECT COUNT(*) FROM alunos_confirmados_2026 WHERE dataconfirmacao BETWEEN :i AND :f");
            $stmt->execute([':i' => $inicio_mes_2026, ':f' => $fim_mes_2026]);
            $total_mes_2026 = (int)$stmt->fetchColumn();

            $var = $total_mes_2025 > 0 ? (($total_mes_2026 - $total_mes_2025) / $total_mes_2025) * 100 : 0;
            $icone = $var >= 0 ? '▲' : '▼';
            $cor   = $var >= 0 ? 'green' : 'red';

            $soma_2025 += $total_mes_2025;
            $soma_2026 += $total_mes_2026;
            $dados_2025[] = $total_mes_2025;
            $dados_2026[] = $total_mes_2026;
            $labels[] = $nomeMes;

            echo "<tr>
                    <td><strong>$nomeMes</strong></td>
                    <td>$total_mes_2025</td>
                    <td>$total_mes_2026</td>
                    <td style='color:$cor; font-weight:bold;'>"
                        . number_format($var, 2, ',', '.') . "% $icone</td>
                  </tr>";
        }

        // Totais e variação geral mensal
        $variacao_total = $soma_2025 > 0 ? (($soma_2026 - $soma_2025) / $soma_2025) * 100 : 0;
        $icone_total = $variacao_total >= 0 ? '▲' : '▼';
        $cor_total   = $variacao_total >= 0 ? 'green' : 'red';

        echo "</tbody>
              <tfoot style='background:#f5f5f5; font-weight:bold;'>
                <tr>
                  <td class='text-right'>TOTAL</td>
                  <td>{$soma_2025}</td>
                  <td>{$soma_2026}</td>
                  <td style='color:{$cor_total}; font-weight:bold;'>
                    " . number_format($variacao_total, 2, ',', '.') . "% {$icone_total}
                  </td>
                </tr>
              </tfoot>
              </table>
              </div>";
              
              
/* ================== COMPARATIVO DO MÊS ATUAL ================== */

// Obtém mês e dia atuais
$mes_atual = date('m');
$dia_atual = date('d');
$nome_mes_atual = [
    '01' => 'Janeiro', '02' => 'Fevereiro', '03' => 'Março', '04' => 'Abril',
    '05' => 'Maio', '06' => 'Junho', '07' => 'Julho', '08' => 'Agosto',
    '09' => 'Setembro', '10' => 'Outubro', '11' => 'Novembro', '12' => 'Dezembro'
][$mes_atual];

$ano_2025 = date('Y') - 1; // ano anterior
$ano_2026 = date('Y');     // ano atual

// Datas de comparação
$inicio_mes_2025 = "$ano_2025-$mes_atual-01";
$fim_dia_2025 = "$ano_2025-$mes_atual-$dia_atual";

$inicio_mes_2026 = "$ano_2026-$mes_atual-01";
$fim_dia_2026 = "$ano_2026-$mes_atual-$dia_atual";

// Consulta: total parcial até hoje nos dois anos
$stmt = $pdo->prepare("SELECT COUNT(*) FROM alunos_confirmados_2025 WHERE dataconfirmacao BETWEEN :i AND :f");
$stmt->execute([':i' => $inicio_mes_2025, ':f' => $fim_dia_2025]);
$total_mes_2025 = (int)$stmt->fetchColumn();

$stmt = $pdo->prepare("SELECT COUNT(*) FROM alunos_confirmados_2026 WHERE dataconfirmacao BETWEEN :i AND :f");
$stmt->execute([':i' => $inicio_mes_2026, ':f' => $fim_dia_2026]);
$total_mes_2026 = (int)$stmt->fetchColumn();

// Cálculo da variação
$variacao_atual = $total_mes_2025 > 0 ? (($total_mes_2026 - $total_mes_2025) / $total_mes_2025) * 100 : 0;
$icone_atual = $variacao_atual >= 0 ? '▲' : '▼';
$cor_atual = $variacao_atual >= 0 ? 'green' : 'red';

// Tabela comparativa
echo '<h5 class="text-center mt-5 mb-3" style="text-transform:uppercase; font-weight:bold;">
        Comparativo Parcial de Matrículas — ' . strtoupper($nome_mes_atual) . ' (' . $ano_2025 . ' x ' . $ano_2026 . ')
      </h5>';

echo '<div class="table-responsive">';
echo '<table class="table table-bordered table-striped text-center">';
echo '<thead style="background:#004085; color:#fff; text-transform:uppercase;">';
echo "<tr><th>Período</th><th>$ano_2025</th><th>$ano_2026</th><th>Variação (%)</th></tr>";
echo '</thead><tbody>';

echo "<tr>
        <td><strong>1º a {$dia_atual} de {$nome_mes_atual}</strong></td>
        <td>{$total_mes_2025}</td>
        <td>{$total_mes_2026}</td>
        <td style='color:{$cor_atual}; font-weight:bold;'>" . number_format($variacao_atual, 2, ',', '.') . "% {$icone_atual}</td>
      </tr>";

echo '</tbody></table></div>';

/* ================== GRÁFICO COMPARATIVO ================== */

// Supondo que já existam os arrays $labels, $dados_2025, $dados_2026
// Adicionamos o comparativo parcial do mês atual ao final dos arrays:
$labels[] = "Parcial - $nome_mes_atual";
$dados_2025[] = $total_mes_2025;
$dados_2026[] = $total_mes_2026;

?>
<div class="mt-5 mb-4">
  <h5 class="text-center mb-3" style="text-transform:uppercase; font-weight:bold;">
    Gráfico Comparativo Mensal de Matrículas (<?= $ano_2025 ?> x <?= $ano_2026 ?>)
  </h5>
  <canvas id="graficoRelatorio" height="120"></canvas>
</div>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
const ctx = document.getElementById('graficoRelatorio').getContext('2d');
new Chart(ctx, {
  type: 'bar',
  data: {
    labels: <?= json_encode($labels) ?>,
    datasets: [
      {
        label: '<?= $ano_2025 ?>',
        data: <?= json_encode($dados_2025) ?>,
        backgroundColor: 'rgba(255, 99, 132, 0.6)',
        borderColor: 'rgba(255, 99, 132, 1)',
        borderWidth: 1
      },
      {
        label: '<?= $ano_2026 ?>',
        data: <?= json_encode($dados_2026) ?>,
        backgroundColor: 'rgba(54, 162, 235, 0.6)',
        borderColor: 'rgba(54, 162, 235, 1)',
        borderWidth: 1
      }
    ]
  },
  options: {
    responsive: true,
    scales: {
      y: { beginAtZero: true, ticks: { precision: 0 } }
    },
    plugins: {
      legend: { position: 'bottom' },
      tooltip: { mode: 'index', intersect: false }
    }
  }
});
</script>
<?php


    } catch (PDOException $e) {
        echo "<div class='alert alert-danger'>Erro ao gerar relatório: " . htmlspecialchars($e->getMessage()) . "</div>";
    }
}


?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <meta charset="UTF-8">
  <title>Relat&oacute;rio de alunos matriculados</title>
  <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
  <style>
     body { font-family: Arial, sans-serif; background-color: #ffffff; margin: 20px; color: #000; }
     table { white-space: nowrap; width: 100%; border-collapse: collapse; background-color: #fff; text-transform: uppercase; }
     th, td { padding: 12px 15px; text-align: left; font-size: 12px; border: 1px solid #000; }
     th { background-color: #000; color: #fff; }
     tr:nth-child(even) { background-color: #f4f4f4; }
     tr:hover { background-color: #e0e0e0; }
     .table-responsive { overflow-x: auto; }
     .table thead th { position: sticky; top: 0; z-index: 2; background-color: #000; color: #fff; }
     @media (max-width: 768px) {
       .table th:first-child, .table td:first-child { position: sticky; left: 0; background-color: #fff; z-index: 3; border-right: 1px solid #000; }
       .table thead th:first-child { z-index: 4; background-color: #000; color: #fff; }
     }
  </style>
</head>
<body class="container-fluid">

<h2 class="text-center text-uppercase">Computo de matr&iacute;culas <?= $proximo_ano ?></h2>
<h5 class="text-right text-uppercase">Atualização: <?= $dataFormatada ?></h5>

<ul class="nav nav-tabs">
  <li class="active"><a data-toggle="tab" href="#edim">Educação Infantil - Matutino</a></li>
  <li><a data-toggle="tab" href="#ediv">Educação Infantil - Vespertino</a></li>
  <li><a data-toggle="tab" href="#f1m">Fundamental I - Matutino</a></li>
  <li><a data-toggle="tab" href="#f1v">Fundamental I - Vespertino</a></li>
  <li><a data-toggle="tab" href="#f2m">Fundamental II - Matutino</a></li>
  <li><a data-toggle="tab" href="#em">Ensino Médio - Matutino</a></li>
  <li><a data-toggle="tab" href="#todas">Todas as Turmas</a></li>
  <li><a data-toggle="tab" href="#alunos">Alunos Matriculados</a></li>
  <li><a data-toggle="tab" href="#relatorios">Comparativo Ano Anterior</a></li>

</ul>
<br>

<div class="tab-content">
  <div id="edim" class="tab-pane fade in active">
    <h4 class="text-uppercase text-center">Educação Infantil - Matutino</h4>
    <?php renderTabela($dadosedim); ?>
  </div>
  <div id="ediv" class="tab-pane fade">
    <h4 class="text-uppercase text-center">Educação Infantil - Vespertino</h4>
    <?php renderTabela($dadosediv); ?>
  </div>
  <div id="f1m" class="tab-pane fade">
    <h4 class="text-uppercase text-center">Fundamental I - Matutino</h4>
    <?php renderTabela($dadosf1m); ?>
  </div>
  <div id="f1v" class="tab-pane fade">
    <h4 class="text-uppercase text-center">Fundamental I - Vespertino</h4>
    <?php renderTabela($dadosf1v); ?>
  </div>
  <div id="f2m" class="tab-pane fade">
    <h4 class="text-uppercase text-center">Fundamental II - Matutino</h4>
    <?php renderTabela($dadosf2m); ?>
  </div>
  <div id="em" class="tab-pane fade">
    <h4 class="text-uppercase text-center">Ensino Médio - Matutino</h4>
    <?php renderTabela($dadosem); ?>
  </div>
  <div id="todas" class="tab-pane fade">
    <h4 class="text-uppercase text-center">Todas as Turmas</h4>
    <?php renderTabela($dadosall); ?>
  </div>
  <div id="alunos" class="tab-pane fade">
    <h4 class="text-uppercase text-center">Alunos Matriculados</h4>
    <?php renderTabelaAlunos($dadosAlunos); ?>
  </div>
  <div id="relatorios" class="tab-pane fade">
  <h4 class="text-uppercase text-center">Relatórios Comparativos</h4>
  <?php renderTabelaRelatorio($pdo); ?>
</div>
</div>



<!-- TABELA INTERMEDIÁRIA -->
<?php

// Define fuso horário (importante para exibir o mês correto no Brasil)
date_default_timezone_set('America/Sao_Paulo');

// Captura o nome do mês atual em português
$mesAtual = ucfirst(strftime('%B')); // Ex: "Novembro"

// Captura o ano atual
$anoAtual = date('Y');

// Monta a string automática
$mesAno = "$mesAtual ($anoAtual)";
?>

<div class="table-responsive tabela-intermediaria">
  <h4 class="text-uppercase text-center">Metas de matrículas para 2026</h4>
  <table class="table table-bordered table-striped">
    <thead>
      <tr style="background:#000; color:#fff; text-transform:uppercase;">
        <th>Acumulados Mês</th>
        <th>Novatos</th>
        <th>Rematrícula</th>
      </tr>
    </thead>
    <tbody>
      <tr>
        <td><?= $mesAno ?></td>
        <td>77</td>
        <td>466</td>
      </tr>
      <tr>
        <td>Atualmente (para 2026)</td>
        <td>
          <?= somaNovatos($dadosall) ?>
          (<?= number_format((somaNovatos($dadosall) / 77) * 100, 2, ',', '.') ?>%)
        </td>
        <td>
          <?= somaVeteranos($dadosall) ?>
          (<?= number_format((somaVeteranos($dadosall) / 466) * 100, 2, ',', '.') ?>%)
        </td>
      </tr>
    </tbody>
  </table>
</div>

<hr>


<!-- TABELA DE TOTAIS GERAIS -->
<?php
// Funções para somar matriculados e vagas esperadas
function somaMatriculados($dados) { $total = 0; foreach ($dados as $row) $total += $row['matriculados']; return $total; }
function somaesp($dados) { $total = 0; foreach ($dados as $row) { $total += $row['vagas_restantes'] - $row['vagas_reais']; } return $total; }

$total_ed_infantil = somaMatriculados($dadosedim) + somaMatriculados($dadosediv);
$total_fund1       = somaMatriculados($dadosf1m) + somaMatriculados($dadosf1v);
$total_fund2       = somaMatriculados($dadosf2m);
$total_medio       = somaMatriculados($dadosem);
$total_geral       = somaMatriculados($dadosall);
?>

<div class="table-responsive tabela-totais">
  <table class="table table-bordered table-striped">
    <thead>
      <tr style="background:#000; color:#fff; text-transform:uppercase;">
        <th>Nível</th>
        <th>Total Matriculados</th>
        <th>Vagas Esperadas</th>
      </tr>
    </thead>
    <tbody>
      <tr><td>Educação Infantil</td><td><?= $total_ed_infantil ?></td><td><?= somaesp(array_merge($dadosedim,$dadosediv)) ?></td></tr>
      <tr><td>Fundamental I</td><td><?= $total_fund1 ?></td><td><?= somaesp(array_merge($dadosf1m,$dadosf1v)) ?></td></tr>
      <tr><td>Fundamental II</td><td><?= $total_fund2 ?></td><td><?= somaesp($dadosf2m) ?></td></tr>
      <tr><td>Ensino Médio</td><td><?= $total_medio ?></td><td><?= somaesp($dadosem) ?></td></tr>
      <tr style="font-weight:bold; background:#000; color:#fff;"><td>Total Geral</td><td><?= $total_geral ?></td><td><?= somaesp($dadosall) ?></td></tr>
    </tbody>
  </table>
</div>

<script>
$(document).ready(function(){
  $('[data-toggle="tooltip"]').tooltip();   
});

$(document).ready(function(){
  $('[data-toggle="tooltip"]').tooltip();   

  // Função para controlar exibição das tabelas extras
  function atualizarVisibilidade() {
    const abaAtiva = $(".nav-tabs li.active a").attr("href");

    // Abas nas quais queremos ocultar as tabelas extras
    const abasOcultas = ["#todas", "#alunos", "#relatorios"];

    if (abasOcultas.includes(abaAtiva)) {
      $(".tabela-intermediaria, .tabela-totais").hide();
    } else {
      $(".tabela-intermediaria, .tabela-totais").show();
    }
  }

  // Executa ao carregar a página
  atualizarVisibilidade();

  // Executa toda vez que o usuário troca de aba
  $('a[data-toggle="tab"]').on('shown.bs.tab', function () {
    atualizarVisibilidade();
  });
});
</script>

</body>
</html>
