<?php
// Incluindo a biblioteca DOMPDF
require 'vendor/autoload.php';  // Se você estiver usando o Composer
use Dompdf\Dompdf;

// Parâmetros da conexão com o banco de dados
$host = "localhost";
$dbname = "kaltekgo_painel";
$user = "kaltekgo_painel";
$password = "painel@2024";

// Criando a conexão
$conn = new mysqli($host, $user, $password, $dbname);

// Verificando a conexão
if ($conn->connect_error) {
    die("Falha na conexão: " . $conn->connect_error);
}

// Consultando os dados
$sql = "SELECT nomeProfessor, disciplinaSeries, salaProfessor, login, senha FROM professor";
$result = $conn->query($sql);

// Iniciando o conteúdo HTML para o PDF com bordas e imagem no topo à esquerda
$html = '
    <style>
        table {
            width: 100%;
            border-collapse: collapse;
        }
        th, td {
            border: 1px solid black;
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #f2f2f2;
        }
        h2 {
            text-align: center;
        }
        .header {
            position: relative;
            text-align: center;
        }
        .header img {
            position: absolute;
            right: 0;
            top: 0;
            width: 100px;
            margin-top: -30px;
        }
    </style>
    <div class="header">
        <img src="https://colegioavila.com.br/wp-content/uploads/2018/11/logo-com-sombra2.png" alt="Logo">
        <h2 style="font-size: 14px; text-transform: uppercase;">Relatório professores reunião dos pais - 2º Trimestre</h2>
    </div>
    <table>
        <thead>
            <tr>
                <th style="font-size: 12px; text-transform: uppercase;">NOME PROFESSOR</th>
                <th style="font-size: 12px; text-transform: uppercase;">DISCIPLINA PROFESSOR</th>
                <th style="font-size: 12px; text-transform: uppercase;">SALA</th>
                <th style="font-size: 12px; text-transform: uppercase;">LOGIN</th>
                <th style="font-size: 12px; text-transform: uppercase;">SENHA</th>
            </tr>
        </thead>
        <tbody>';

// Preenchendo a tabela com os dados
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $html .= '<tr>';
        $html .= '<td style="font-size: 12px; text-transform: uppercase;">' . $row["nomeProfessor"] . '</td>';
        $html .= '<td style="font-size: 12px; text-transform: uppercase;">' . $row["disciplinaSeries"] . '</td>';
        $html .= '<td style="font-size: 12px; text-transform: uppercase;">' . $row["salaProfessor"] . '</td>';
        $html .= '<td class="text-lowercase">' . $row["login"] . '</td>';
        $html .= '<td class="text-lowercase">' . $row["senha"] . '</td>';
        $html .= '</tr>';
    }
} else {
    $html .= '<tr><td colspan="5" style="text-align: center;">Nenhum dado encontrado.</td></tr>';
}

$html .= '
        </tbody>
    </table>';

// Fechando a conexão
$conn->close();

// Criando a instância do DOMPDF
$dompdf = new Dompdf();

// Definindo o conteúdo HTML
$dompdf->loadHtml($html);

// Habilitar carregamento de imagens remotas
$dompdf->set_option('isRemoteEnabled', true);

// Definindo o tamanho do papel e a orientação
$dompdf->setPaper('A4', 'portrait');

// Renderizando o HTML como PDF
$dompdf->render();

// Enviando o PDF para o browser (força download)
$dompdf->stream("relatorio_professores.pdf", array("Attachment" => false));
