<?php
$servidor = "localhost";
$usuario = "kaltekgo_painel";
$senha = "painel@2024";
$dbname = "kaltekgo_painel";
$conn = mysqli_connect($servidor, $usuario, $senha, $dbname);

if (!$conn) {
    die("Falha na conexão: " . mysqli_connect_error());
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Painel de Senha</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@400;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: "Barlow", sans-serif;
            font-weight: 700;
            background-color: #396f33;
            color: #fff;
            margin: 0;
            padding: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            text-align: center;
            text-transform: uppercase;
        }

        .painel {
            width: 100%;
            max-width: 1200px;
            background-color: #0a1e55;
            padding: 20px;
            border-radius: 10px;
            box-sizing: border-box;
            margin: 10px;
        }

        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            flex-wrap: wrap;
        }

        .header h1 {
            font-size: 24px;
            margin: 0;
        }

        .img img {
            max-width: 100px;
            height: auto;
        }

        .senha-atual {
            font-size: 3.5em;
            margin: 15px 0;
            color: #ffff00;
        }

        .guiche-atual {
            font-size: 2.5em;
            margin: 20px 0;
            color: #ffffff;
        }

        table {
            width: 100%;
            margin-top: 20px;
            border-collapse: collapse;
        }

        table th, table td {
            padding: 8px;
            font-size: 2em;
        }

        table th {
            background-color: #001c4a;
        }

        table td {
            background-color: #0a1e55;
        }

        .relogio {
            font-size: 1.2em;
            margin-top: 20px;
        }

        @media (max-width: 768px) {
            .senha-atual { font-size: 1.6em; }
            .guiche-atual { font-size: 1.2em; }
            table th, table td { font-size: 0.9em; }
            .img img { max-width: 80px; }
        }

        @media (max-width: 480px) {
            .painel { padding: 15px; }
            .senha-atual { font-size: 1.8em; }
            .guiche-atual { font-size: 1.2em; }
            .relogio { font-size: 1.2em; }
            table th, table td { font-size: 1.1em; }
        }
    </style>
</head>
<body>
    <div class="painel">
        <div class="header">
            <h1>Painel Atendimento</h1>
            <span class="img">
                <img src="https://colegioavila.com.br/wp-content/uploads/2019/02/logo-chanfrado01.png" alt="Logo">
            </span>
        </div>

        <div class="senha-atual" id="senhaAtual">
            <strong>Senha Atual: ---</strong>
        </div>

        <div class="guiche-atual" id="infoAtual">
            <strong>Professor</strong> - <strong>Disciplina</strong> - <strong>Sala</strong>
        </div>

        <table>
            <thead>
                <tr>
                    <th>Senha</th>
                    <th>Professor</th>
                    <th>Sala</th>
                </tr>
            </thead>
            <tbody id="listaSenhas">
                <!-- Linhas serão carregadas via JavaScript -->
            </tbody>
        </table>

        <p class="relogio" id="relogio"></p>
    </div>

    <audio id="alertaSom" src="som.mp3" preload="auto"></audio>

    <script>
        let senhaAnterior = '';

        function atualizarSenha() {
            fetch('atualizar_senha.php')
                .then(response => response.json())
                .then(data => {
                    if (data && data.senha && data.senha !== senhaAnterior) {
                        senhaAnterior = data.senha;

                        document.getElementById("senhaAtual").innerHTML =
                            `<strong>Senha Atual: ${data.senha}</strong>`;

                        document.getElementById("infoAtual").innerHTML =
                            `<strong>${data.nomeProfessor}</strong> - 
                             <strong>${data.disciplinaProfessor}</strong> - 
                             <strong>Sala ${data.salaProfessor}</strong>`;

                        document.getElementById("alertaSom").play().catch(() => {});
                    }
                });
        }

        function atualizarListaSenhas() {
            fetch('lista_senhas.php')
                .then(response => response.text())
                .then(html => {
                    document.getElementById("listaSenhas").innerHTML = html;
                });
        }

        function atualizarRelogio() {
            const agora = new Date();
            const hora = agora.toLocaleString('pt-BR');
            document.getElementById("relogio").textContent = hora;
        }

        setInterval(atualizarSenha, 10000);
        setInterval(atualizarListaSenhas, 10000);
        setInterval(atualizarRelogio, 1000);

        atualizarSenha();
        atualizarListaSenhas();
        atualizarRelogio();
    </script>
</body>
</html>
