<?php
session_start();
if(!isset($_SESSION['usuarioId'])) {
    header("Location: index.php");
    exit;
}
$salaProfessor = $_SESSION['salaProfessor'];
$disciplina = $_SESSION['usuarioDisciplina'];
$novoProfessor = $_SESSION['usuarioNome'];
$idProfessor = $_SESSION['usuarioIdProfessor'];
?>
<?php
// Conectar ao banco de dados (ajuste as configurações conforme necessário)
$host = 'localhost';
$db = 'kaltekgo_painel';
$user = 'kaltekgo_painel';
$pass = 'painel@2024';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Erro na conexão: " . $e->getMessage());
}

// Função para obter a última senha usando query com idProfessor obtido via SESSION
function obterUltimaSenha($pdo) {
    // Verifica se o idProfessor está definido na sessão
    if (isset($_SESSION['usuarioIdProfessor'])) {
        $idProfessor = $_SESSION['usuarioIdProfessor'];
        
        // Realiza a consulta diretamente, procurando pelo idProfessor da sessão
        $stmt = $pdo->query("SELECT senha FROM senhasPainel WHERE idProfessor = '$idProfessor' ORDER BY id DESC LIMIT 1");
        
        // Busca o resultado
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        
        // Retorna a senha encontrada ou 0 caso não exista
        return $row ? $row['senha'] : 0;
    } else {
        // Caso o idProfessor não esteja na sessão, retorna 0 ou lança um erro, se necessário
        return 0;
    }
}

// Função para inserir a nova senha
function inserirNovaSenha($pdo, $novaSenha, $novoProfessor, $disciplina, $idProfessor, $salaProfessor) {
    $stmt = $pdo->prepare("INSERT INTO senhasPainel (senha, nomeProfessor, disciplinaProfessor, idProfessor, salaProfessor) VALUES (:senha, :professor, :disciplina, :idProfessor, :salaProfessor)");
    $stmt->execute([
        'senha' => $novaSenha,
        'professor' => $novoProfessor,
        'disciplina' => $disciplina,
        'idProfessor' => $idProfessor,
        'salaProfessor' => $salaProfessor  // Corrigido para coincidir com o bind parameter na query
    ]);
}


// Quando o botão for clicado
if (isset($_POST['liberar_senha'])) {
    // Obtém a última senha e soma 1
    $ultimaSenha = obterUltimaSenha($pdo);
    $novaSenha = $ultimaSenha + 1;
    
    // Insere a nova senha no banco de dados
    inserirNovaSenha($pdo, $novaSenha, $novoProfessor, $disciplina, $idProfessor, $salaProfessor);
    
    // Redireciona usando JavaScript
    echo "<script>window.location.href = 'https://avilagoiania.kaltekgoiania.com.br/painel/professor/professorSenhaLiberar.php';</script>";
    exit;
}

// Função para atualizar a senha existente
function atualizarSenha($pdo, $idProfessor) {
    $stmt = $pdo->prepare("UPDATE senhasPainel SET status = :status WHERE idProfessor = :idProfessor");
    $stmt->execute([
        'status' => 'inativo',
        'idProfessor' => $idProfessor
    ]);
}

// Quando o botão for clicado
if (isset($_POST['encerrar_senha'])) {

    // Atualiza a senha existente no banco de dados
    atualizarSenha($pdo, $idProfessor);

    // Redireciona usando JavaScript
    echo "<script>window.location.href = 'https://avilagoiania.kaltekgoiania.com.br/painel/professor/professorSenhaLiberar.php';</script>";
    exit;
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Barlow:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">
    <title>Chamar Senha</title>
    <style>
        body {
            font-family: "Barlow", sans-serif;
            font-weight: 400;
            font-style: normal; 
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            background-color: #396f33;
            color: white;
            margin-top: -60px;
	    text-transform: uppercase;
            
        }
        .container {
            text-align: center;
            
            
        }
        .senha-atual {
            font-size: 26px;
            margin-bottom: 20px;
        }
        .liberar-btn {font-family: "Barlow", sans-serif;
            font-weight: 700;
            font-style: normal;
            background-color: #ffff00;
            color: #0a1e55;
            padding: 15px 30px;
            border: none;
            font-size: 16px;
            cursor: pointer;
            text-transform: uppercase;
        }
        .liberar-btn:hover {
            background-color: #cccc00;
        }
    </style>
</head>
<body>

    <div class="container">
        <h1>Chamar Senha</h1>
        <?php echo $novoProfessor; ?> / <?php echo $disciplina; ?> / sala: <?php echo $salaProfessor; ?>
        <div class="senha-atual">
            <?php
            // Exibe a última senha
            $ultimaSenha = obterUltimaSenha($pdo);
            echo "Última senha chamada: <strong>".$ultimaSenha."</strong>";
           ?>
        </div>

        <!-- Formulário para o botão -->
        <form method="POST">
            <button class="liberar-btn" name="liberar_senha">Chamar Próxima Senha</button><br></br>
            <button class="liberar-btn" name="encerrar_senha">Encerrar senha</button>
        </form>
        <p><a href="logout.php"><button class="liberar-btn" name="sair">Sair</button></a></p>
    </div>

</body>
</html>