<?php
session_start();
if (!isset($_SESSION['usuarioId'])) {
    header("Location: index.php");
    exit;
}

$idProfessor = $_SESSION['usuarioIdProfessor'];
$salaProfessor = $_SESSION['salaProfessor'];
$novoProfessor = $_SESSION['usuarioNome'];

// Dados de conexão
$host = 'localhost';
$db = 'kaltekgo_painel';
$user = 'kaltekgo_painel';
$pass = 'painel@2024';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Buscar disciplinaSeries do professor
    $stmt = $pdo->prepare("SELECT disciplinaSeries FROM professor WHERE idProfessor = :id");
    $stmt->execute(['id' => $idProfessor]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($row) {
        $disciplina = $row['disciplinaSeries'];
    } else {
        echo "Nenhum professor encontrado.";
        exit;
    }

} catch (PDOException $e) {
    die("Erro na conexão: " . $e->getMessage());
}

// Função: última senha
function obterUltimaSenha($pdo) {
    $stmt = $pdo->prepare("SELECT senha FROM senhasPainelFundamental WHERE idProfessor = :idProfessor ORDER BY id DESC LIMIT 1");
    $stmt->execute(['idProfessor' => $_SESSION['usuarioIdProfessor']]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);
    return $row ? $row['senha'] : 0;
}

// Função: inserir nova senha
function inserirNovaSenha($pdo, $novaSenha, $novoProfessor, $disciplina, $idProfessor, $salaProfessor) {
    $stmt = $pdo->prepare("INSERT INTO senhasPainelFundamental (senha, nomeProfessor, disciplinaProfessor, idProfessor, salaProfessor) VALUES (:senha, :professor, :disciplina, :idProfessor, :salaProfessor)");
    $stmt->execute([
        'senha' => $novaSenha,
        'professor' => $novoProfessor,
        'disciplina' => $disciplina,
        'idProfessor' => $idProfessor,
        'salaProfessor' => $salaProfessor
    ]);
}

// Função: encerrar senha
function atualizarSenha($pdo, $idProfessor) {
    $stmt = $pdo->prepare("UPDATE senhasPainelFundamental SET status = 'inativo' WHERE idProfessor = :idProfessor");
    $stmt->execute(['idProfessor' => $idProfessor]);
}

// Botões
if (isset($_POST['liberar_senha'])) {
    $ultimaSenha = obterUltimaSenha($pdo);
    $novaSenha = $ultimaSenha + 1;
    inserirNovaSenha($pdo, $novaSenha, $novoProfessor, $disciplina, $idProfessor, $salaProfessor);
    header("Location: professorSenhaLiberar.php");
    exit;
}

if (isset($_POST['encerrar_senha'])) {
    atualizarSenha($pdo, $idProfessor);
    header("Location: professorSenhaLiberar.php");
    exit;
}

if (isset($_POST['troca_sala']) && !empty($_POST['nova_sala'])) {
    $novaSala = $_POST['nova_sala'];
    //$_SESSION['salaProfessor'] = $novaSala;
    $stmt = $pdo->prepare("UPDATE professor SET disciplinaSeries = :sala WHERE idProfessor = :idProfessor");
    $stmt->execute(['sala' => $novaSala, 'idProfessor' => $idProfessor]);
    header("Location: professorSenhaLiberar.php");
    exit;
}

?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Chamar Senha</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #396f33;
            font-family: "Barlow", sans-serif;
            text-transform: uppercase;
            color: white;
        }

        .senha-atual strong {
            font-size: 1.5rem;
        }

        @media (max-width: 576px) {
            h1 {
                font-size: 1.5rem;
            }
            .senha-atual strong {
                font-size: 1.5rem;
            }
            .btn {
                font-size: 1.3rem;
            }
            select.form-select {
                font-size: 1.3rem;
            }
            .prof strong {
                font-size: 1.8rem;
            }
        }
    </style>
</head>
<body>

<div class="container-fluid text-center mt-4 px-3">
    <h1>Chamar Senha</h1>
    <p class="mb-3 prof"><?php echo $novoProfessor; ?> / <?php echo $disciplina; ?> / Sala: <?php echo $_SESSION['salaProfessor']; ?></p>

    <div class="senha-atual mb-4">
        <?php
        $ultimaSenha = obterUltimaSenha($pdo);
        echo "<strong>Última senha chamada: ".$ultimaSenha."</strong>";
        ?>
    </div>

    <form method="POST" class="row g-3 justify-content-center">
        <div class="col-12 col-md-6 d-grid">
            <button class="btn btn-warning fw-bold" name="liberar_senha">Chamar Próxima Senha</button>
        </div>

        <div class="col-12 col-md-6">
            <select class="form-select text-uppercase" name="nova_sala" required>
                <option selected disabled>Selecione a nova sala</option>
                <option value="Infantil 2A">Infantil 2A</option>
                <option value="Infantil 2C">Infantil 2C</option>
                <option value="Infantil 4C">Infantil 4C</option>
                <option value="Infantil 5A">Infantil 5A</option>
                <option value="Infantil 5B">Infantil 5B</option>
                <option value="Infantil 5C">Infantil 5C</option>
                <option value="1º Ano D">1º Ano D</option>
                <option value="1º Ano A">1º Ano A</option>
                <option value="1º Ano B">1º Ano B</option>
                <option value="1º Ano C">1º Ano C</option>
                <option value="1º Ano D">1º Ano D</option>
                <option value="2º Ano A">2º Ano A</option>
                <option value="2º Ano B">2º Ano B</option>
                <option value="2º Ano C">2º Ano C</option>
                <option value="2º Ano D">2º Ano D</option>
                <option value="4º Ano (Port/Geo)">4º Ano (Port/Geo)</option>
                <option value="4º Ano (Mat/Cien/Hist)">4º Ano (Mat/Cien/Hist)</option>
                <option value="5º Ano (Port/Geo/Hist)">5º Ano (Port/Geo/Hist)</option>
                <option value="5º Ano (Mat/Cien)">5º Ano (Mat/Cien)</option>
              
                
            </select>
        </div>

        <div class="col-12 col-md-6 d-grid">
            <button class="btn btn-primary fw-bold" name="troca_sala">Trocar Sala</button>
        </div>

        <div class="col-12 col-md-6 d-grid">
            <button class="btn btn-danger fw-bold" name="encerrar_senha">Encerrar Senha</button>
        </div>

        <div class="col-12 col-md-6 d-grid">
            <a href="logout.php" class="btn btn-dark fw-bold">Sair</a>
        </div>
    </form>
</div>

</body>
</html>
