<?php
// Conexão com o banco de dados
$pdo = new PDO("mysql:host=localhost;dbname=kaltekgo_painel", "kaltekgo_painel", "painel@2024");

// Consulta para buscar todos os professores
$stmt = $pdo->query("SELECT nomeProfessor, disciplinaSeries, salaProfessor, login, senha FROM professor");
$professores = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Lista de Professores</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
</head>
<body style="background-color: #f9f9f9;">
    <div class="container">
        <h2 class="text-center" style="margin-top: 30px;">Professores Cadastrados</h2>
        <div class="panel panel-default">
            <div class="panel-heading text-uppercase">
                Lista de Professores
            </div>
            <div class="panel-body">
                <table class="table table-bordered table-striped table-hover text-uppercase">
                    <thead>
                        <tr>
                            <th>Nome</th>
                            <th>Disciplinas / Séries</th>
                            <th>Sala</th>
                            <th>Login</th>
                            <th>Senha</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (count($professores) > 0): ?>
                            <?php foreach ($professores as $prof): ?>
                                <tr>
                                    <td><?= htmlspecialchars($prof['nomeProfessor']) ?></td>
                                    <td><?= htmlspecialchars($prof['disciplinaSeries']) ?></td>
                                    <td><?= htmlspecialchars($prof['salaProfessor']) ?></td>
                                    <td><?= htmlspecialchars($prof['login']) ?></td>
                                    <td><?= htmlspecialchars($prof['senha']) ?></td>
                                </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="5" class="text-center">Nenhum professor encontrado.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</body>
</html>