<?php
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    echo "<pre>";
    print_r($_POST); // Aqui você pode salvar no banco
    echo "</pre>";
    exit;
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Pesquisa Sistêmica - Educação Infantil</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
    <style>
        body {
            background: #f4f6f9;
            font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;
        }
        .container {
            max-width: 1000px;
            background: #fff;
            padding: 25px 35px;
            border-radius: 10px;
            box-shadow: 0 3px 8px rgba(0,0,0,0.2);
        }
        h2 {
            margin-bottom: 25px;
            font-weight: bold;
            color: #2c3e50;
        }
        .nav-tabs > li > a {
            font-weight: bold;
            color: #555;
        }
        .nav-tabs > li.active > a {
            background: #3498db;
            color: #fff !important;
            border-radius: 5px 5px 0 0;
        }
        .tab-content {
            margin-top: 20px;
        }
        .panel {
            border-radius: 8px;
            box-shadow: 0 1px 4px rgba(0,0,0,0.1);
            margin-bottom: 20px;
        }
        .panel-heading {
            background: #3498db !important;
            color: #fff !important;
            font-weight: bold;
            border-radius: 8px 8px 0 0;
        }
        .form-group label {
            font-weight: bold;
            color: #333;
        }
        .btn-success {
            background: #2ecc71;
            border: none;
            padding: 12px 20px;
            font-size: 16px;
            border-radius: 30px;
            transition: 0.3s;
        }
        .btn-success:hover {
            background: #27ae60;
        }
        .nota {
            width: 120px;
            display: inline-block;
        }
    </style>
</head>
<body>
<div class="container">
    <h2 class="text-center">📊 Pesquisa Sistêmica 2025 – Educação Infantil</h2>
    <form method="POST" action="">
        
        <!-- Abas -->
        <ul class="nav nav-tabs">
            <li class="active"><a data-toggle="tab" href="#s1">1. Identificação</a></li>
            <li><a data-toggle="tab" href="#s2">2. Professores</a></li>
            <li><a data-toggle="tab" href="#s3">3. Material</a></li>
            <li><a data-toggle="tab" href="#s4">4. Coordenação</a></li>
            <li><a data-toggle="tab" href="#s5">5. Infraestrutura</a></li>
            <li><a data-toggle="tab" href="#s6">6. Extracurriculares</a></li>
            <li><a data-toggle="tab" href="#s7">7. Integral</a></li>
            <li><a data-toggle="tab" href="#s8">8. Eventos</a></li>
            <li><a data-toggle="tab" href="#s9">9. Clima</a></li>
            <li><a data-toggle="tab" href="#s10">10. Percepções</a></li>
        </ul>

        <div class="tab-content">
            <!-- SEÇÃO 1 -->
            <div id="s1" class="tab-pane fade in active">
                <div class="panel panel-default">
                    <div class="panel-heading">Identificação</div>
                    <div class="panel-body">
                        <div class="form-group"><label>Nome do Responsável</label><input type="text" class="form-control" name="responsavel"></div>
                        <div class="form-group"><label>CPF</label><input type="text" class="form-control" name="cpf"></div>
                        <div class="form-group"><label>E-mail</label><input type="email" class="form-control" name="email"></div>
                        <div class="form-group"><label>Nome do Aluno</label><input type="text" class="form-control" name="aluno"></div>
                        <div class="form-group"><label>Segmento</label><input type="text" class="form-control" name="segmento"></div>
                        <div class="form-group"><label>Série/Turma</label><input type="text" class="form-control" name="turma"></div>
                    </div>
                </div>
            </div>

            <!-- SEÇÃO 2 -->
            <div id="s2" class="tab-pane fade">
                <div class="panel panel-default">
                    <div class="panel-heading">Avaliação dos Professores</div>
                    <div class="panel-body">
                        <p>Nota de 1 a 10</p>
                        <?php
                        $turmas = [
                            "Infantil 2 A" => ["Nara (Regente)", "Isabela (Inglês)", "Rafhael (Ed. Física)", "Victor (Música)", "Brenda (Ballet)"],
                            "Infantil 2 C" => ["Nara (Regente)", "Paula (Inglês)", "Rafhael (Ed. Física)", "Victor (Música)", "Brenda (Ballet)"],
                            "Infantil 3 A" => ["Sarah (Regente)", "Isabela (Inglês)", "Rafhael (Ed. Física)", "Victor (Música)", "Brenda (Ballet)"],
                            "Infantil 3 C" => ["Karynne (Regente)", "Paula (Inglês)", "Rafhael (Ed. Física)", "Victor (Música)", "Brenda (Ballet)"],
                            "Infantil 3 D" => ["Aline (Regente)", "Isabela (Inglês)", "Rafhael (Ed. Física)", "Victor (Música)", "Brenda (Ballet)"],
                            "Infantil 4 A" => ["Ádria (Regente)", "Isabela (Inglês)", "Rafhael (Ed. Física)", "Victor (Música)"],
                            "Infantil 4 C" => ["Izadora (Regente)", "Paula (Inglês)", "Rafhael (Ed. Física)", "Victor (Música)"],
                            "Infantil 5 A" => ["Lucinéia (Regente)", "Isabela (Inglês)", "Rafhael (Ed. Física)", "Victor (Música)"],
                            "Infantil 5 B" => ["Izadora (Regente)", "Isabela (Inglês)", "Rafhael (Ed. Física)", "Victor (Música)"],
                            "Infantil 5 C" => ["Lucinéia (Regente)", "Paula (Inglês)", "Rafhael (Ed. Física)", "Victor (Música)"],
                        ];
                        foreach ($turmas as $turma => $profs) {
                            echo "<h5><b>$turma</b></h5>";
                            foreach ($profs as $prof) {
                                echo "<div class='form-group'>
                                        <label>$prof</label>
                                        <input type='number' min='1' max='10' class='form-control nota' name='professores[$turma][$prof]'>
                                      </div>";
                            }
                        }
                        ?>
                        <div class="form-group"><label>Comentários:</label><textarea class="form-control" name="comentario_professores"></textarea></div>
                    </div>
                </div>
            </div>

            <!-- Repete o mesmo padrão de PANEL para SEÇÕES 3 até 10 -->
            <div id="s3" class="tab-pane fade"><div class="panel panel-default"><div class="panel-heading">Material Didático e Plataformas</div><div class="panel-body"><?php $questoes=["Material didático (FTD) é bem estruturado","Conteúdo do material é claro e atualizado","Plataformas digitais (Iônica) são úteis"];foreach($questoes as $i=>$q){echo "<div class='form-group'><label>$q</label><input type='number' min='1' max='10' class='form-control nota' name='material[$i]'></div>";} ?><div class="form-group"><label>Comentários:</label><textarea class="form-control" name="comentario_material"></textarea></div></div></div></div>

            <div id="s4" class="tab-pane fade"><div class="panel panel-default"><div class="panel-heading">Direção, Coordenação e Administração</div><div class="panel-body"><?php $questoes=["A atuação da Direção é profissional, acessível e resolutiva.","A coordenação está disponível, acolhe e se comunica com clareza.","A coordenação acompanha bem o desenvolvimento dos alunos.","A Orientação Educacional está disponível, acolhe e se comunica com clareza.","A Orientação Educacional acompanha bem o desenvolvimento dos alunos.","O atendimento administrativo é cordial e eficiente."];foreach($questoes as $i=>$q){echo "<div class='form-group'><label>$q</label><input type='number' min='1' max='10' class='form-control nota' name='coordenacao[$i]'></div>";} ?><div class="form-group"><label>Comentários:</label><textarea class="form-control" name="comentario_coordenacao"></textarea></div></div></div></div>

            <div id="s5" class="tab-pane fade"><div class="panel panel-default"><div class="panel-heading">Infraestrutura e Ambiente Escolar</div><div class="panel-body"><?php $questoes=["Qualidade e conservação da estrutura física.","Recursos pedagógicos e tecnológicos disponíveis.","Segurança e acolhimento escolar."];foreach($questoes as $i=>$q){echo "<div class='form-group'><label>$q</label><input type='number' min='1' max='10' class='form-control nota' name='infraestrutura[$i]'></div>";} ?><div class="form-group"><label>Comentários:</label><textarea class="form-control" name="comentario_infra"></textarea></div></div></div></div>

            <div id="s6" class="tab-pane fade"><div class="panel panel-default"><div class="panel-heading">Atividades Extracurriculares</div><div class="panel-body"><?php $questoes=["Variedade e organização.","Contribuição para o desenvolvimento do aluno."];foreach($questoes as $i=>$q){echo "<div class='form-group'><label>$q</label><input type='number' min='1' max='10' class='form-control nota' name='extracurriculares[$i]'></div>";} ?><div class="form-group"><label>Comentários:</label><textarea class="form-control" name="comentario_extracurriculares"></textarea></div></div></div></div>

            <div id="s7" class="tab-pane fade"><div class="panel panel-default"><div class="panel-heading">Ensino Integral</div><div class="panel-body"><?php $questoes=["A proposta do Ensino Integral atende às necessidades da sua família.","O planejamento das atividades é claro e bem comunicado.","As refeições e rotinas são bem organizadas.","O ambiente é acolhedor e seguro.","Professor responsável pelo Integral."];foreach($questoes as $i=>$q){echo "<div class='form-group'><label>$q</label><input type='number' min='1' max='10' class='form-control nota' name='integral[$i]'></div>";} ?><div class="form-group"><label>Comentários:</label><textarea class="form-control" name="comentario_integral"></textarea></div></div></div></div>

            <div id="s8" class="tab-pane fade"><div class="panel panel-default"><div class="panel-heading">Eventos</div><div class="panel-body"><?php $eventos=["Recepção de volta às aulas","Dia da Mulher","JICA","Aula Pública de Ballet","ArraíÁvila (Festa Junina)","Talentos/Vernissage x Feira Científica Cultural (FCC)","Thanksgiving","Festa do Dia das Mães","AcampÁvila","Troca de Faixas - Karatê","Troca de Cordas - Capoeira","Dia das Crianças"];foreach($eventos as $i=>$e){echo "<div class='form-group'><label>$e</label><input type='number' min='1' max='10' class='form-control nota' name='eventos[$i]'></div>";} ?><div class="form-group"><label>Comentários:</label><textarea class="form-control" name="comentario_eventos"></textarea></div></div></div></div>

            <div id="s9" class="tab-pane fade"><div class="panel panel-default"><div class="panel-heading">Clima Escolar</div><div class="panel-body"><?php $questoes=["Pertencimento e acolhimento.","Relações respeitosas.","Bem-estar emocional."];foreach($questoes as $i=>$q){echo "<div class='form-group'><label>$q</label><input type='number' min='1' max='10' class='form-control nota' name='clima[$i]'></div>";} ?><div class="form-group"><label>Comentários:</label><textarea class="form-control" name="comentario_clima"></textarea></div></div></div></div>

            <div id="s10" class="tab-pane fade"><div class="panel panel-default"><div class="panel-heading">Recomendações e Percepções</div><div class="panel-body"><div class="form-group"><label>De 1 a 10, quanto você recomendaria o Colégio Ávila?</label><input type="number" min="1" max="10" class="form-control nota" name="recomendacao"></div><div class="form-group"><label>O que mais influenciou sua nota?</label><textarea class="form-control" name="influencia_nota"></textarea></div><div class="form-group"><label>Algo tem te preocupado em relação ao percurso escolar?</label><textarea class="form-control" name="preocupacoes"></textarea></div><div class="form-group"><label>O que pode influenciar a decisão de mudar de escola?</label><textarea class="form-control" name="mudanca"></textarea></div><div class="form-group"><label>O que mais fortalece sua escolha de permanecer no Colégio?</label><textarea class="form-control" name="permanencia"></textarea></div></div></div></div>

        </div>

        <br>
        <div class="text-center">
            <button type="submit" class="btn btn-success btn-lg">✅ Enviar Respostas</button>
        </div>
    </form>
</div>
</body>
</html>
