<?php
$matricula = $_GET['matricula'] ?? '';
$turma = $_GET['turma'] ?? '';
$nome = $_GET['nome'] ?? '';

// === CONEXÃO COM O BANCO ===
$host = "localhost";
$db   = "kaltekgo_avila";
$user = "kaltekgo_admin";
$pass = "kaltek@2024";

$conn = new mysqli($host, $user, $pass, $db);
if ($conn->connect_error) {
    die("Erro ao conectar: " . $conn->connect_error);
}
$conn->set_charset("utf8");

// === GRUPOS DE PERGUNTAS ===
$grupos = [
    1 => ['inicio' => 10, 'fim' => 19, 'titulo' => 'Aspectos Sócios Afetivos'],
    2 => ['inicio' => 20, 'fim' => 30, 'titulo' => 'Cognição, Linguagem Oral e Escrita'],
    3 => ['inicio' => 31, 'fim' => 34, 'titulo' => 'Raciocínio Lógico'],
    4 => ['inicio' => 35, 'fim' => 39, 'titulo' => 'Motricidade'],
    5 => ['inicio' => 40, 'fim' => 43, 'titulo' => 'Postura Família x Escola'],
    6 => ['inicio' => null, 'fim' => null, 'titulo' => 'Observações Finais']
];

// === BUSCA RESPOSTAS SALVAS ===
$respostas = [];
$sqlResp = "SELECT idPergunta, resposta FROM questionario_respostas WHERE idAluno = '$matricula'";
$res = $conn->query($sqlResp);
if ($res && $res->num_rows > 0) {
    while ($r = $res->fetch_assoc()) {
        $respostas[$r['idPergunta']] = $r['resposta'];
    }
}

// === BUSCA OBSERVAÇÕES ===
$obs = [
    'comportamentos' => '',
    'aspecto_cognitivo' => '',
    'raciocinio_logico' => '',
    'consideracoes' => ''
];
$sqlObs = "SELECT * FROM questionario_observacoes WHERE idAluno = '$matricula' LIMIT 1";
$res2 = $conn->query($sqlObs);
if ($res2 && $res2->num_rows > 0) {
    $obs = $res2->fetch_assoc();
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="UTF-8">
<title>Editar Questionário</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>

<style>
body {
    font-family: Arial, sans-serif;
    background-color: #fff;
    margin: 20px;
    color: #000;
}
table {
    width: 100%;
    border-collapse: collapse;
    background-color: #fff;
}
th, td {
    padding: 8px;
    text-align: left;
    font-size: 12px;
    border: 1px solid #000;
}
th {
    background-color: #000;
    color: #fff;
}
tr:nth-child(even) { background-color: #f4f4f4; }
tr:hover { background-color: #e0e0e0; }
.table-responsive { overflow-x: auto; margin-top: 15px; }
.table-container { display: none; }
.table-container.active { display: block; }
textarea {
    width: 100%;
    height: 100px;
    resize: vertical;
    font-size: 13px;
}
.char-count {
    font-size: 11px;
    color: #666;
    text-align: right;
}
</style>
</head>
<body>

<div class="container">
    <h3 class="text-center">📋 Ficha de Desenvolvimento — Educação Infantil</h3>
    <p><strong>Matrícula:</strong> <?= htmlspecialchars($matricula) ?><br>
       <strong>Nome:</strong> <?= htmlspecialchars($nome) ?><br>
       <strong>Turma:</strong> <?= htmlspecialchars($turma) ?></p>

    <form action="salvar_respostas.php" method="POST" id="formQuestionario">
        <?php foreach ($grupos as $pagina => $range): ?>
            <div class="table-container <?= $pagina === 1 ? 'active' : '' ?>" id="pagina<?= $pagina ?>">
                <h4 class="text-primary">
                    Parte <?= $pagina ?> — <?= htmlspecialchars($range['titulo']) ?>
                </h4>

                <?php if ($pagina < 6): ?>
                    <!-- Tabelas de perguntas -->
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th style="width:70%"><?= htmlspecialchars($range['titulo']) ?></th>
                                    <th class="text-center">CS</th>
                                    <th class="text-center">ED</th>
                                    <th class="text-center">RMA</th>
                                </tr>
                            </thead>
                            <tbody>
                            <?php
                            $sql = "SELECT * FROM questionario_perguntas 
                                    WHERE id BETWEEN {$range['inicio']} AND {$range['fim']} 
                                    AND idTurma = '2' ORDER BY id";
                            $res = $conn->query($sql);
                            if ($res && $res->num_rows > 0):
                                while ($row = $res->fetch_assoc()):
                                    $idPerg = $row['id'];
                                    $resp = $respostas[$idPerg] ?? '';
                            ?>
                                <tr>
                                    <td><?= htmlspecialchars($row['texto']) ?></td>
                                    <td class="text-center">
                                        <input type="radio" name="p<?= $idPerg ?>" value="CS" <?= ($resp == 'CS') ? 'checked' : '' ?>>
                                    </td>
                                    <td class="text-center">
                                        <input type="radio" name="p<?= $idPerg ?>" value="ED" <?= ($resp == 'ED') ? 'checked' : '' ?>>
                                    </td>
                                    <td class="text-center">
                                        <input type="radio" name="p<?= $idPerg ?>" value="RMA" <?= ($resp == 'RMA') ? 'checked' : '' ?>>
                                    </td>
                                </tr>
                            <?php
                                endwhile;
                            else:
                                echo "<tr><td colspan='4' class='text-center text-muted'>Nenhuma pergunta encontrada.</td></tr>";
                            endif;
                            ?>
                            </tbody>
                        </table>
                    </div>

                <?php else: ?>
                    <!-- Página 6: Observações -->
                    <div class="form-group">
                        <label>Comportamentos e aspectos socioemocionais:</label>
                        <textarea name="comportamentos" maxlength="1000" required><?= htmlspecialchars($obs['comportamentos'] ?? '') ?></textarea>
                        <div class="char-count" data-for="comportamentos"></div>
                    </div>

                    <div class="form-group">
                        <label>Aspecto cognitivo da linguagem oral e escrita:</label>
                        <textarea name="aspecto_cognitivo" maxlength="1000" required><?= htmlspecialchars($obs['aspecto_cognitivo'] ?? '') ?></textarea>
                        <div class="char-count" data-for="aspecto_cognitivo"></div>
                    </div>

                    <div class="form-group">
                        <label>Aspecto cognitivo do raciocínio lógico-matemático:</label>
                        <textarea name="raciocinio_logico" maxlength="1000" required><?= htmlspecialchars($obs['raciocinio_logico'] ?? '') ?></textarea>
                        <div class="char-count" data-for="raciocinio_logico"></div>
                    </div>

                    <div class="form-group">
                        <label>Considerações finais:</label>
                        <textarea name="consideracoes" maxlength="1000" required><?= htmlspecialchars($obs['consideracoes'] ?? '') ?></textarea>
                        <div class="char-count" data-for="consideracoes"></div>
                    </div>
                <?php endif; ?>

                <!-- Botões de navegação -->
                <div class="row" style="margin-top:15px;">
                    <div class="col-xs-6 text-left">
                        <?php if ($pagina > 1): ?>
                            <button type="button" class="btn btn-primary prev" data-prev="<?= $pagina - 1 ?>">⬅ Voltar</button>
                        <?php endif; ?>
                    </div>

                    <div class="col-xs-6 text-right">
                        <?php if ($pagina < count($grupos)): ?>
                            <button type="button" class="btn btn-primary next" data-next="<?= $pagina + 1 ?>">Próxima Página ➡</button>
                        <?php else: ?>
                            <button type="submit" class="btn btn-success">💾 Salvar Alterações</button>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>

        <input type="hidden" name="idAluno" value="<?= htmlspecialchars($matricula) ?>">
        <input type="hidden" name="idTurma" value="5">
        <input type="hidden" name="nomeTurma" value="<?= htmlspecialchars($turma) ?>">
        <input type="hidden" name="nomeProfessor" value="PROF. ANA LÚCIA">
        <input type="hidden" name="nomeAluno" value="<?= htmlspecialchars($nome) ?>">
    </form>
</div>

<script>
$(document).ready(function(){
    // Navegação
    $(".next").click(function(){
        var next = $(this).data("next");
        $(".table-container").removeClass("active");
        $("#pagina" + next).addClass("active");
        $("html, body").animate({ scrollTop: 0 }, "slow");
    });

    $(".prev").click(function(){
        var prev = $(this).data("prev");
        $(".table-container").removeClass("active");
        $("#pagina" + prev).addClass("active");
        $("html, body").animate({ scrollTop: 0 }, "slow");
    });

    // Contador de caracteres
    $("textarea").each(function(){
        var max = $(this).attr("maxlength");
        var len = $(this).val().length;
        var name = $(this).attr("name");
        $(".char-count[data-for='"+name+"']").text(len + " / " + max);
    });

    $("textarea").on("input", function(){
        var max = $(this).attr("maxlength");
        var len = $(this).val().length;
        var name = $(this).attr("name");
        $(".char-count[data-for='"+name+"']").text(len + " / " + max);
    });
});
</script>

</body>
</html>
