<?php
$matricula = $_GET['matricula'] ?? '';
$turma = $_GET['turma'] ?? '';
$nome = $_GET['nome'] ?? '';

if (strpos($turma, 'INFANTIL 2') !== false) {
    $infantil = 'INFANTIL 2';
} elseif (strpos($turma, 'INFANTIL 3') !== false) {
    $infantil = 'INFANTIL 3';
} elseif (strpos($turma, 'INFANTIL 4') !== false) {
    $infantil = 'INFANTIL 4';
} elseif (strpos($turma, 'INFANTIL 5') !== false) {
    $infantil = 'INFANTIL 5';
} else {
    $infantil = $turma; // Caso não se encaixe em nenhum dos padrões acima
}



// questionario.php
// Conexão com o banco
$host = "localhost";
$db   = "kaltekgo_avila";
$user = "kaltekgo_admin";
$pass = "kaltek@2024";

$conn = new mysqli($host, $user, $pass, $db);
if ($conn->connect_error) {
    die("Erro ao conectar: " . $conn->connect_error);
}
$conn->set_charset("utf8");

// === Define grupos de perguntas de acordo com o nível ===
switch ($infantil) {
    case 'INFANTIL 2':
        $grupos = [
            1 => ['inicio' => 1, 'fim' => 9, 'titulo' => 'Aspectos Sócio Afetivos - INFANTIL 2'],
            2 => ['inicio' => 10, 'fim' => 18, 'titulo' => 'Cognição, Linguagem Oral e Escrita - INFANTIL 2'],
            3 => ['inicio' => 19, 'fim' => 25, 'titulo' => 'Raciocínio Lógico - INFANTIL 2'],
            4 => ['inicio' => 26, 'fim' => 30, 'titulo' => 'Motricidade - INFANTIL 2'],
            5 => ['inicio' => 31, 'fim' => 34, 'titulo' => 'Postura Família x Escola - INFANTIL 2'],
            6 => ['inicio' => null, 'fim' => null, 'titulo' => 'Observações Finais']
        ];
        break;

    case 'INFANTIL 3':
        $grupos = [
            1 => ['inicio' => 10, 'fim' => 19, 'titulo' => 'Aspectos Sócios Afetivos - INFANTIL 3'],
            2 => ['inicio' => 20, 'fim' => 30, 'titulo' => 'Cognição, Linguagem Oral e Escrita - INFANTIL 3'],
            3 => ['inicio' => 31, 'fim' => 34, 'titulo' => 'Raciocínio Lógico - INFANTIL 3'],
            4 => ['inicio' => 35, 'fim' => 39, 'titulo' => 'Motricidade - INFANTIL 3'],
            5 => ['inicio' => 40, 'fim' => 43, 'titulo' => 'Postura Família x Escola - INFANTIL 3'],
            6 => ['inicio' => null, 'fim' => null, 'titulo' => 'Observações Finais']
        ];
        break;

    case 'INFANTIL 4':
        $grupos = [
            1 => ['inicio' => 44, 'fim' => 53, 'titulo' => 'Aspectos Sócios Afetivos - INFANTIL 4'],
            2 => ['inicio' => 54, 'fim' => 63, 'titulo' => 'Cognição, Linguagem Oral e Escrita - INFANTIL 4'],
            3 => ['inicio' => 64, 'fim' => 69, 'titulo' => 'Raciocínio Lógico - INFANTIL 4'],
            4 => ['inicio' => 70, 'fim' => 75, 'titulo' => 'Motricidade - INFANTIL 4'],
            5 => ['inicio' => 76, 'fim' => 80, 'titulo' => 'Postura Família x Escola - INFANTIL 4'],
            6 => ['inicio' => null, 'fim' => null, 'titulo' => 'Observações Finais']
        ];
        break;

    case 'INFANTIL 5':
        $grupos = [
            1 => ['inicio' => 81, 'fim' => 90, 'titulo' => 'Aspectos Sócios Afetivos - INFANTIL 5'],
            2 => ['inicio' => 91, 'fim' => 100, 'titulo' => 'Cognição, Linguagem Oral e Escrita - INFANTIL 5'],
            3 => ['inicio' => 101, 'fim' => 106, 'titulo' => 'Raciocínio Lógico - INFANTIL 5'],
            4 => ['inicio' => 107, 'fim' => 113, 'titulo' => 'Motricidade - INFANTIL 5'],
            5 => ['inicio' => 114, 'fim' => 118, 'titulo' => 'Postura Família x Escola - INFANTIL 5'],
            6 => ['inicio' => null, 'fim' => null, 'titulo' => 'Observações Finais']
        ];
        break;

    default:
        $grupos = [
            1 => ['inicio' => 10, 'fim' => 19, 'titulo' => 'Aspectos Sócios Afetivos'],
            2 => ['inicio' => 20, 'fim' => 30, 'titulo' => 'Cognição, Linguagem Oral e Escrita'],
            3 => ['inicio' => 31, 'fim' => 34, 'titulo' => 'Raciocínio Lógico'],
            4 => ['inicio' => 35, 'fim' => 39, 'titulo' => 'Motricidade'],
            5 => ['inicio' => 40, 'fim' => 43, 'titulo' => 'Postura Família x Escola'],
            6 => ['inicio' => null, 'fim' => null, 'titulo' => 'Observações Finais']
        ];
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="UTF-8">
<title>Questionário em 6 Tabelas</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>

<style>
body {
    font-family: Arial, sans-serif;
    background-color: #fff;
    margin: 20px;
    color: #000;
}
table {
    white-space: nowrap;
    width: 100%;
    border-collapse: collapse;
    background-color: #fff;
}
th, td {
    padding: 10px;
    text-align: left;
    font-size: 12px;
    border: 1px solid #000;
}
th {
    background-color: #000;
    color: #fff;
}
tr:nth-child(even) { background-color: #f4f4f4; }
tr:hover { background-color: #e0e0e0; }
.table-responsive { overflow-x: auto; margin-top: 15px; }
.table-container { display: none; }
.table-container.active { display: block; }
.text-center { text-align: center; }
textarea {
    width: 100%;
    height: 120px;
    resize: vertical;
    font-size: 13px;
}
.char-count {
    font-size: 11px;
    color: #666;
    text-align: right;
}
</style>
</head>
<body>

<div class="container">
    <h3 class="text-center" style="margin-bottom:25px;">📋 FICHA DE DESENVOLVIMENTO DA EDUCAÇÃO INFANTIL</h3>
    <p>Matrícula: <?php echo $matricula;?><br>Nome Aluno: <?php echo $nome;?><br>Turma: <?php echo $turma;?></p>
    <form action="salvar_respostas.php" method="POST" id="formQuestionario">
        <?php foreach ($grupos as $pagina => $range): ?>
            <div class="table-container <?= $pagina === 1 ? 'active' : '' ?>" id="pagina<?= $pagina ?>">
                <h4 class="text-primary">
                    Parte <?= $pagina ?> — <?= htmlspecialchars($range['titulo']) ?>
                </h4>

                <?php if ($pagina < 6): ?>
                    <!-- Páginas com perguntas -->
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th style="width:70%"><?= htmlspecialchars($range['titulo']) ?></th>
                                    <th class="text-center">CS</th>
                                    <th class="text-center">ED</th>
                                    <th class="text-center">RMA</th>
                                </tr>
                            </thead>
                            <tbody>
                            <?php
                            $sql = "SELECT * FROM questionario_perguntas 
                                    WHERE id BETWEEN {$range['inicio']} AND {$range['fim']} 
                                    AND identificadorturma LiKE '%$infantil%' ORDER BY id";
                            $res = $conn->query($sql);
                            if ($res && $res->num_rows > 0):
                                while ($row = $res->fetch_assoc()):
                            ?>
                                <tr>
                                    <td><?= htmlspecialchars($row['texto']) ?></td>
                                    <td class="text-center"><input type="radio" name="p<?= $row['id'] ?>" value="CS" required></td>
                                    <td class="text-center"><input type="radio" name="p<?= $row['id'] ?>" value="ED"></td>
                                    <td class="text-center"><input type="radio" name="p<?= $row['id'] ?>" value="RMA"></td>
                                </tr>
                            <?php
                                endwhile;
                            else:
                                echo "<tr><td colspan='4' class='text-center text-muted'>Nenhuma pergunta encontrada.</td></tr>";
                            endif;
                            ?>
                            </tbody>
                        </table>
                    </div>

                <?php else: ?>
                    <!-- Página 6 com Textareas -->
                    <div class="form-group">
                        <label>Comportamentos e aspectos socioemocionais:</label>
                        <textarea name="comportamentos" maxlength="1000" required></textarea>
                        <div class="char-count" data-for="comportamentos">0 / 1000</div>
                    </div>

                    <div class="form-group">
                        <label>Aspecto cognitivo da linguagem oral e escrita:</label>
                        <textarea name="aspecto_cognitivo" maxlength="1000" required></textarea>
                        <div class="char-count" data-for="aspecto_cognitivo">0 / 1000</div>
                    </div>

                    <div class="form-group">
                        <label>Aspecto cognitivo do raciocínio lógico-matemático:</label>
                        <textarea name="raciocinio_logico" maxlength="1000" required></textarea>
                        <div class="char-count" data-for="raciocinio_logico">0 / 1000</div>
                    </div>

                    <div class="form-group">
                        <label>Considerações finais:</label>
                        <textarea name="consideracoes" maxlength="1000" required></textarea>
                        <div class="char-count" data-for="consideracoes">0 / 1000</div>
                    </div>
                <?php endif; ?>

                <!-- Botões -->
                <div class="row" style="margin-top:15px;">
                    <div class="col-xs-6 text-left">
                        <?php if ($pagina > 1): ?>
                            <button type="button" class="btn btn-primary prev" data-prev="<?= $pagina - 1 ?>">⬅ Voltar</button>
                        <?php endif; ?>
                    </div>

                    <div class="col-xs-6 text-right">
                        <?php if ($pagina < count($grupos)): ?>
                            <button type="button" class="btn btn-primary next" data-next="<?= $pagina + 1 ?>">Próxima Página ➡</button>
                        <?php else: ?>
                            <button type="submit" class="btn btn-success">Gravar Respostas</button>
                        <?php endif; ?>
                        <button type="submit" class="btn btn-success text-center">Voltar a turma</button>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
        <input type="hidden" name="idAluno" value="<?php echo $matricula;?>">
<input type="hidden" name="idTurma" value="5">
<input type="hidden" name="nomeTurma" value="<?php echo $turma;?>">
<input type="hidden" name="nomeProfessor" value="PROF. ANA LÚCIA">
<input type="hidden" name="nomeAluno" value="<?php echo $nome;?>">
    </form>
</div>

<script>
$(document).ready(function(){
    $(".next").click(function(){
        var next = $(this).data("next");
        $(".table-container").removeClass("active");
        $("#pagina" + next).addClass("active");
        $("html, body").animate({ scrollTop: 0 }, "slow");
    });

    $(".prev").click(function(){
        var prev = $(this).data("prev");
        $(".table-container").removeClass("active");
        $("#pagina" + prev).addClass("active");
        $("html, body").animate({ scrollTop: 0 }, "slow");
    });

    // Contador de caracteres para os textareas
    $("textarea").on("input", function(){
        var max = $(this).attr("maxlength");
        var len = $(this).val().length;
        var target = $(this).attr("name");
        $(".char-count[data-for='" + target + "']").text(len + " / " + max);
    });
});
</script>

</body>
</html>
